/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.impl.AbstractAuditQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;

public class EntitiesAtRevisionQuery
extends AbstractAuditQuery {
    private final Number revision;

    public EntitiesAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, Number revision) {
        super(verCfg, versionsReader, cls);
        this.revision = revision;
    }

    public EntitiesAtRevisionQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, Number revision) {
        super(verCfg, versionsReader, cls, entityName);
        this.revision = revision;
    }

    @Override
    public List list() {
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        MiddleIdData referencedIdData = new MiddleIdData(verEntCfg, this.verCfg.getEntCfg().get(this.entityName).getIdMappingData(), null, this.entityName, this.verCfg.getEntCfg().isVersioned(this.entityName));
        this.verCfg.getAuditStrategy().addEntityAtRevisionRestriction(this.verCfg.getGlobalCfg(), this.qb, revisionPropertyPath, verEntCfg.getRevisionEndFieldName(), true, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e", "e2");
        this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.entityName, this.qb, this.qb.getRootParameters());
        }
        Query query = this.buildQuery();
        List<String> params = Arrays.asList(query.getNamedParameters());
        if (params.contains("revision")) {
            query.setParameter("revision", (Object)this.revision);
        }
        List queryResult = query.list();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList result = new ArrayList();
        this.entityInstantiator.addInstancesFromVersionsEntities(this.entityName, result, queryResult, this.revision);
        return result;
    }
}

