/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import java.util.Properties;
import org.dom4j.Element;
import org.hibernate.envers.configuration.metadata.MetadataTools;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.SerializableToBlobType;
import org.hibernate.type.Type;

public final class BasicMetadataGenerator {
    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        Type type = value.getType();
        if (type instanceof BasicType || type instanceof SerializableToBlobType || "org.hibernate.type.PrimitiveByteArrayBlobType".equals(type.getClass().getName())) {
            if (parent != null) {
                boolean addNestedType = value instanceof SimpleValue && ((SimpleValue)value).getTypeParameters() != null;
                String typeName = type.getName();
                if (typeName == null) {
                    typeName = type.getClass().getName();
                }
                Element prop_mapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), addNestedType ? null : typeName, propertyAuditingData.isForceInsertable() || insertable, key);
                MetadataTools.addColumns(prop_mapping, value.getColumnIterator());
                if (addNestedType) {
                    Properties typeParameters = ((SimpleValue)value).getTypeParameters();
                    Element type_mapping = prop_mapping.addElement("type");
                    type_mapping.addAttribute("name", typeName);
                    for (Object object : typeParameters.keySet()) {
                        String keyType = (String)object;
                        String property = typeParameters.getProperty(keyType);
                        if (property == null) continue;
                        Element type_param = type_mapping.addElement("param");
                        type_param.addAttribute("name", keyType);
                        type_param.setText(property);
                    }
                }
            }
            if (mapper != null) {
                mapper.add(propertyAuditingData.getPropertyData());
            }
        } else {
            return false;
        }
        return true;
    }
}

