/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.id.AbstractCompositeIdMapper;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.exception.AuditException;

public class MultipleIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    public MultipleIdMapper(String compositeIdClass) {
        super(compositeIdClass);
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (IdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        this.mapToMapFromId(data, obj);
    }

    @Override
    public boolean mapToEntityFromMap(Object obj, Map data) {
        boolean ret = true;
        for (IdMapper idMapper : this.ids.values()) {
            ret &= idMapper.mapToEntityFromMap(obj, data);
        }
        return ret;
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        MultipleIdMapper ret = new MultipleIdMapper(this.compositeIdClass);
        for (PropertyData propertyData : this.ids.keySet()) {
            String propertyName = propertyData.getName();
            ret.ids.put(propertyData, new SingleIdMapper(new PropertyData(prefix + propertyName, propertyData)));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        Object ret;
        if (data == null) {
            return null;
        }
        try {
            ret = Thread.currentThread().getContextClassLoader().loadClass(this.compositeIdClass).newInstance();
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromEntity(ret, data);
        }
        return ret;
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (Map.Entry propertyData : data.entrySet()) {
            ret.add(new QueryParameterData((String)propertyData.getKey(), propertyData.getValue()));
        }
        return ret;
    }
}

