/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntityInstantiator;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.AuditQuery;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.order.AuditOrder;
import org.hibernate.envers.query.projection.AuditProjection;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.Pair;
import org.hibernate.envers.tools.Triple;
import org.hibernate.envers.tools.query.QueryBuilder;

public abstract class AbstractAuditQuery
implements AuditQuery {
    protected EntityInstantiator entityInstantiator;
    protected List<AuditCriterion> criterions;
    protected String entityName;
    protected String entityClassName;
    protected String versionsEntityName;
    protected QueryBuilder qb;
    protected boolean hasProjection;
    protected boolean hasOrder;
    protected final AuditConfiguration verCfg;
    protected final AuditReaderImplementor versionsReader;
    private Integer maxResults;
    private Integer firstResult;
    private Boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private Integer timeout;
    private LockOptions lockOptions = new LockOptions(LockMode.NONE);

    protected AbstractAuditQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls) {
        this(verCfg, versionsReader, cls, cls.getName());
    }

    protected AbstractAuditQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, String entityName) {
        this.verCfg = verCfg;
        this.versionsReader = versionsReader;
        this.criterions = new ArrayList<AuditCriterion>();
        this.entityInstantiator = new EntityInstantiator(verCfg, versionsReader);
        this.entityClassName = cls.getName();
        this.entityName = entityName;
        this.versionsEntityName = verCfg.getAuditEntCfg().getAuditEntityName(entityName);
        this.qb = new QueryBuilder(this.versionsEntityName, "e__");
    }

    protected Query buildQuery() {
        Query query = this.qb.toQuery(this.versionsReader.getSession());
        this.setQueryProperties(query);
        return query;
    }

    protected List buildAndExecuteQuery() {
        Query query = this.buildQuery();
        return query.list();
    }

    public abstract List list() throws AuditException;

    @Override
    public List getResultList() throws AuditException {
        return this.list();
    }

    @Override
    public Object getSingleResult() throws AuditException, NonUniqueResultException, NoResultException {
        List result = this.list();
        if (result == null || result.size() == 0) {
            throw new NoResultException();
        }
        if (result.size() > 1) {
            throw new NonUniqueResultException();
        }
        return result.get(0);
    }

    @Override
    public AuditQuery add(AuditCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public AuditQuery addProjection(AuditProjection projection) {
        Triple<String, String, Boolean> projectionData = projection.getData(this.verCfg);
        this.hasProjection = true;
        String propertyName = CriteriaTools.determinePropertyName(this.verCfg, this.versionsReader, this.entityName, projectionData.getSecond());
        this.qb.addProjection(projectionData.getFirst(), propertyName, projectionData.getThird());
        return this;
    }

    @Override
    public AuditQuery addOrder(AuditOrder order) {
        this.hasOrder = true;
        Pair<String, Boolean> orderData = order.getData(this.verCfg);
        String propertyName = CriteriaTools.determinePropertyName(this.verCfg, this.versionsReader, this.entityName, orderData.getFirst());
        this.qb.addOrder(propertyName, orderData.getSecond());
        return this;
    }

    @Override
    public AuditQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public AuditQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public AuditQuery setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @Override
    public AuditQuery setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    @Override
    public AuditQuery setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AuditQuery setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @Override
    public AuditQuery setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public AuditQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public AuditQuery setLockMode(LockMode lockMode) {
        this.lockOptions.setLockMode(lockMode);
        return this;
    }

    public AuditQuery setLockOptions(LockOptions lockOptions) {
        LockOptions.copy((LockOptions)lockOptions, (LockOptions)this.lockOptions);
        return this;
    }

    protected void setQueryProperties(Query query) {
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults.intValue());
        }
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            query.setCacheMode(this.cacheMode);
        }
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        if (this.lockOptions != null && this.lockOptions.getLockMode() != LockMode.NONE) {
            query.setLockMode("e__", this.lockOptions.getLockMode());
        }
    }
}

