/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.relation.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;

public class EntityInstantiator {
    private final AuditConfiguration verCfg;
    private final AuditReaderImplementor versionsReader;

    public EntityInstantiator(AuditConfiguration verCfg, AuditReaderImplementor versionsReader) {
        this.verCfg = verCfg;
        this.versionsReader = versionsReader;
    }

    public Object createInstanceFromVersionsEntity(String entityName, Map versionsEntity, Number revision) {
        Object ret;
        if (versionsEntity == null) {
            return null;
        }
        String type = this.verCfg.getEntCfg().getEntityNameForVersionsEntityName((String)versionsEntity.get("$type$"));
        if (type != null) {
            entityName = type;
        }
        IdMapper idMapper = this.verCfg.getEntCfg().get(entityName).getIdMapper();
        Map originalId = (Map)versionsEntity.get(this.verCfg.getAuditEntCfg().getOriginalIdPropName());
        this.replaceNonAuditIdProxies(versionsEntity, revision);
        Object primaryKey = idMapper.mapToIdFromMap(originalId);
        if (this.versionsReader.getFirstLevelCache().contains(entityName, revision, primaryKey)) {
            return this.versionsReader.getFirstLevelCache().get(entityName, revision, primaryKey);
        }
        try {
            EntityConfiguration entCfg = this.verCfg.getEntCfg().get(entityName);
            if (entCfg == null) {
                entCfg = this.verCfg.getEntCfg().getNotVersionEntityConfiguration(entityName);
            }
            Class cls = ReflectHelper.classForName((String)entCfg.getEntityClassName());
            ret = ReflectHelper.getDefaultConstructor((Class)cls).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
        this.versionsReader.getFirstLevelCache().put(entityName, revision, primaryKey, ret);
        this.verCfg.getEntCfg().get(entityName).getPropertyMapper().mapToEntityFromMap(this.verCfg, ret, versionsEntity, primaryKey, this.versionsReader, revision);
        idMapper.mapToEntityFromMap(ret, originalId);
        this.versionsReader.getFirstLevelCache().putOnEntityNameCache(primaryKey, revision, ret, entityName);
        return ret;
    }

    private void replaceNonAuditIdProxies(Map versionsEntity, Number revision) {
        Map originalId = (Map)versionsEntity.get(this.verCfg.getAuditEntCfg().getOriginalIdPropName());
        for (Object key : originalId.keySet()) {
            Class entityClass;
            Object value = originalId.get(key);
            if (!(value instanceof HibernateProxy)) continue;
            HibernateProxy hibernateProxy = (HibernateProxy)value;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            String entityName = initializer.getEntityName();
            Serializable entityId = initializer.getIdentifier();
            if (!this.verCfg.getEntCfg().isVersioned(entityName)) continue;
            String entityClassName = this.verCfg.getEntCfg().get(entityName).getEntityClassName();
            try {
                entityClass = ReflectHelper.classForName((String)entityClassName);
            }
            catch (ClassNotFoundException e) {
                throw new AuditException(e);
            }
            ToOneDelegateSessionImplementor delegate = new ToOneDelegateSessionImplementor(this.versionsReader, entityClass, entityId, revision, RevisionType.DEL.equals(versionsEntity.get(this.verCfg.getAuditEntCfg().getRevisionTypePropName())), this.verCfg);
            originalId.put(key, this.versionsReader.getSessionImplementor().getFactory().getEntityPersister(entityName).createProxy(entityId, (SessionImplementor)delegate));
        }
    }

    public void addInstancesFromVersionsEntities(String entityName, Collection addTo, List<Map> versionsEntities, Number revision) {
        for (Map versionsEntity : versionsEntities) {
            addTo.add(this.createInstanceFromVersionsEntity(entityName, versionsEntity, revision));
        }
    }

    public AuditConfiguration getAuditConfiguration() {
        return this.verCfg;
    }

    public AuditReaderImplementor getAuditReaderImplementor() {
        return this.versionsReader;
    }
}

