/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class PropertyAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private String otherPropertyName;
    private String op;

    public PropertyAuditExpression(PropertyNameGetter propertyNameGetter, String otherPropertyName, String op) {
        this.propertyNameGetter = propertyNameGetter;
        this.otherPropertyName = otherPropertyName;
        this.op = op;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, propertyName);
        CriteriaTools.checkPropertyNotARelation(auditCfg, entityName, this.otherPropertyName);
        parameters.addWhere(propertyName, this.op, this.otherPropertyName);
    }
}

