/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.AbstractRelationQueryGenerator;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public final class TwoEntityQueryGenerator
extends AbstractRelationQueryGenerator {
    private final String queryString;
    private final String queryRemovedString;

    public TwoEntityQueryGenerator(GlobalConfiguration globalCfg, AuditEntitiesConfiguration verEntCfg, AuditStrategy auditStrategy, String versionsMiddleEntityName, MiddleIdData referencingIdData, MiddleIdData referencedIdData, boolean revisionTypeInId, MiddleComponentData ... componentData) {
        super(verEntCfg, referencingIdData, revisionTypeInId);
        QueryBuilder commonPart = this.commonQueryPart(referencedIdData, versionsMiddleEntityName, verEntCfg.getOriginalIdPropName());
        QueryBuilder validQuery = commonPart.deepCopy();
        QueryBuilder removedQuery = commonPart.deepCopy();
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, validQuery, validQuery.getRootParameters(), true, componentData);
        this.createValidAndRemovedDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, removedQuery, componentData);
        this.queryString = this.queryToString(validQuery);
        this.queryRemovedString = this.queryToString(removedQuery);
    }

    private QueryBuilder commonQueryPart(MiddleIdData referencedIdData, String versionsMiddleEntityName, String originalIdPropertyName) {
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        QueryBuilder qb = new QueryBuilder(versionsMiddleEntityName, "ee__");
        qb.addFrom(referencedIdData.getAuditEntityName(), "e__");
        qb.addProjection("new list", "ee__, e__", false, false);
        Parameters rootParameters = qb.getRootParameters();
        referencedIdData.getPrefixedMapper().addIdsEqualToQuery(rootParameters, eeOriginalIdPropertyPath, referencedIdData.getOriginalMapper(), "e__." + originalIdPropertyName);
        this.referencingIdData.getPrefixedMapper().addNamedIdEqualsToQuery(rootParameters, originalIdPropertyName, true);
        return qb;
    }

    private void createValidDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, String versionsMiddleEntityName, QueryBuilder qb, Parameters rootParameters, boolean inclusive, MiddleComponentData ... componentData) {
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        String originalIdPropertyName = this.verEntCfg.getOriginalIdPropName();
        String eeOriginalIdPropertyPath = "ee__." + originalIdPropertyName;
        String revisionTypePropName = this.getRevisionTypePath();
        auditStrategy.addEntityAtRevisionRestriction(globalCfg, qb, rootParameters, "e__." + revisionPropertyPath, "e__." + this.verEntCfg.getRevisionEndFieldName(), false, referencedIdData, revisionPropertyPath, originalIdPropertyName, "e__", "e2__", inclusive);
        auditStrategy.addAssociationAtRevisionRestriction(qb, rootParameters, revisionPropertyPath, this.verEntCfg.getRevisionEndFieldName(), true, this.referencingIdData, versionsMiddleEntityName, eeOriginalIdPropertyPath, revisionPropertyPath, originalIdPropertyName, "ee__", inclusive, componentData);
        rootParameters.addWhereWithNamedParam(revisionTypePropName, "!=", "delrevisiontype");
        rootParameters.addWhereWithNamedParam("e__." + revisionTypePropName, false, "!=", "delrevisiontype");
    }

    private void createValidAndRemovedDataRestrictions(GlobalConfiguration globalCfg, AuditStrategy auditStrategy, MiddleIdData referencedIdData, String versionsMiddleEntityName, QueryBuilder remQb, MiddleComponentData ... componentData) {
        Parameters disjoint = remQb.getRootParameters().addSubParameters("or");
        Parameters valid = disjoint.addSubParameters("and");
        Parameters removed = disjoint.addSubParameters("and");
        String revisionPropertyPath = this.verEntCfg.getRevisionNumberPath();
        String revisionTypePropName = this.getRevisionTypePath();
        this.createValidDataRestrictions(globalCfg, auditStrategy, referencedIdData, versionsMiddleEntityName, remQb, valid, false, componentData);
        removed.addWhereWithNamedParam(revisionPropertyPath, "=", "revision");
        removed.addWhereWithNamedParam("e__." + revisionPropertyPath, false, "=", "revision");
        removed.addWhereWithNamedParam(revisionTypePropName, "=", "delrevisiontype");
        removed.addWhereWithNamedParam("e__." + revisionTypePropName, false, "=", "delrevisiontype");
    }

    @Override
    protected String getQueryString() {
        return this.queryString;
    }

    @Override
    protected String getQueryRemovedString() {
        return this.queryRemovedString;
    }
}

