/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.impl.AbstractAuditQuery;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.proxy.HibernateProxy;

public class RevisionsOfEntityQuery
extends AbstractAuditQuery {
    private final boolean selectEntitiesOnly;
    private final boolean selectDeletedEntities;

    public RevisionsOfEntityQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        super(verCfg, versionsReader, cls);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
    }

    public RevisionsOfEntityQuery(AuditConfiguration verCfg, AuditReaderImplementor versionsReader, Class<?> cls, String entityName, boolean selectEntitiesOnly, boolean selectDeletedEntities) {
        super(verCfg, versionsReader, cls, entityName);
        this.selectEntitiesOnly = selectEntitiesOnly;
        this.selectDeletedEntities = selectDeletedEntities;
    }

    private Number getRevisionNumber(Map versionsEntity) {
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        String originalId = verEntCfg.getOriginalIdPropName();
        String revisionPropertyName = verEntCfg.getRevisionFieldName();
        Object revisionInfoObject = ((Map)versionsEntity.get(originalId)).get(revisionPropertyName);
        if (revisionInfoObject instanceof HibernateProxy) {
            return (Number)((HibernateProxy)revisionInfoObject).getHibernateLazyInitializer().getIdentifier();
        }
        return this.verCfg.getRevisionInfoNumberReader().getRevisionNumber(revisionInfoObject);
    }

    @Override
    public List list() throws AuditException {
        AuditEntitiesConfiguration verEntCfg = this.verCfg.getAuditEntCfg();
        if (!this.selectDeletedEntities) {
            this.qb.getRootParameters().addWhereWithParam(verEntCfg.getRevisionTypePropName(), "<>", (Object)RevisionType.DEL);
        }
        for (AuditCriterion criterion : this.criterions) {
            criterion.addToQuery(this.verCfg, this.versionsReader, this.entityName, this.qb, this.qb.getRootParameters());
        }
        if (!this.hasProjection && !this.hasOrder) {
            String revisionPropertyPath = verEntCfg.getRevisionNumberPath();
            this.qb.addOrder(revisionPropertyPath, true);
        }
        if (!this.selectEntitiesOnly) {
            this.qb.addFrom(this.verCfg.getAuditEntCfg().getRevisionInfoEntityName(), "r");
            this.qb.getRootParameters().addWhere(this.verCfg.getAuditEntCfg().getRevisionNumberPath(), true, "=", "r.id", false);
        }
        List queryResult = this.buildAndExecuteQuery();
        if (this.hasProjection) {
            return queryResult;
        }
        ArrayList<Object> entities = new ArrayList<Object>();
        String revisionTypePropertyName = verEntCfg.getRevisionTypePropName();
        for (Object resultRow : queryResult) {
            Object revisionData;
            Map versionsEntity;
            if (this.selectEntitiesOnly) {
                versionsEntity = (Map)resultRow;
                revisionData = null;
            } else {
                Object[] arrayResultRow = (Object[])resultRow;
                versionsEntity = (Map)arrayResultRow[0];
                revisionData = arrayResultRow[1];
            }
            Number revision = this.getRevisionNumber(versionsEntity);
            Object entity = this.entityInstantiator.createInstanceFromVersionsEntity(this.entityName, versionsEntity, revision);
            if (!this.selectEntitiesOnly) {
                entities.add(new Object[]{entity, revisionData, versionsEntity.get(revisionTypePropertyName)});
                continue;
            }
            entities.add(entity);
        }
        return entities;
    }
}

