/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.metadata;

import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.envers.configuration.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.metadata.MetadataTools;
import org.hibernate.envers.configuration.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.entities.EntityConfiguration;
import org.hibernate.envers.entities.IdMappingData;
import org.hibernate.envers.entities.PropertyData;
import org.hibernate.envers.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.entities.mapper.id.IdMapper;
import org.hibernate.envers.entities.mapper.relation.OneToOneNotOwningMapper;
import org.hibernate.envers.entities.mapper.relation.OneToOnePrimaryKeyJoinColumnMapper;
import org.hibernate.envers.entities.mapper.relation.ToOneIdMapper;
import org.hibernate.envers.tools.MappingTools;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;

public final class ToOneRelationMetadataGenerator {
    private final AuditMetadataGenerator mainGenerator;

    ToOneRelationMetadataGenerator(AuditMetadataGenerator auditMetadataGenerator) {
        this.mainGenerator = auditMetadataGenerator;
    }

    void addToOne(Element parent, PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, boolean insertable) {
        boolean nonInsertableFake;
        String referencedEntityName = ((ToOne)value).getReferencedEntityName();
        IdMappingData idMapping = this.mainGenerator.getReferencedIdMappingData(entityName, referencedEntityName, propertyAuditingData, true);
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(propertyAuditingData.getName());
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneRelation(propertyAuditingData.getName(), referencedEntityName, relMapper, insertable);
        if (!insertable && propertyAuditingData.isForceInsertable()) {
            nonInsertableFake = true;
            insertable = true;
        } else {
            nonInsertableFake = false;
        }
        Element properties = (Element)idMapping.getXmlRelationMapping().clone();
        properties.addAttribute("name", propertyAuditingData.getName());
        MetadataTools.prefixNamesInPropertyElement(properties, lastPropertyPrefix, MetadataTools.getColumnNameIterator(value.getColumnIterator()), false, insertable);
        for (Object o : properties.content()) {
            Element element = (Element)o;
            element.setParent(null);
            parent.add(element);
        }
        PropertyData propertyData = propertyAuditingData.getPropertyData();
        mapper.addComposite(propertyData, new ToOneIdMapper(relMapper, propertyData, referencedEntityName, nonInsertableFake));
    }

    void addOneToOneNotOwning(PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName) {
        OneToOne propertyValue = (OneToOne)value;
        String owningReferencePropertyName = propertyValue.getReferencedPropertyName();
        EntityConfiguration configuration = this.mainGenerator.getEntitiesConfigurations().get(entityName);
        if (configuration == null) {
            throw new MappingException("An audited relation to a non-audited entity " + entityName + "!");
        }
        IdMappingData ownedIdMapping = configuration.getIdMappingData();
        if (ownedIdMapping == null) {
            throw new MappingException("An audited relation to a non-audited entity " + entityName + "!");
        }
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(owningReferencePropertyName);
        String referencedEntityName = propertyValue.getReferencedEntityName();
        IdMapper ownedIdMapper = ownedIdMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneNotOwningRelation(propertyAuditingData.getName(), owningReferencePropertyName, referencedEntityName, ownedIdMapper);
        PropertyData propertyData = propertyAuditingData.getPropertyData();
        mapper.addComposite(propertyData, new OneToOneNotOwningMapper(entityName, referencedEntityName, owningReferencePropertyName, propertyData));
    }

    void addOneToOnePrimaryKeyJoinColumn(PropertyAuditingData propertyAuditingData, Value value, CompositeMapperBuilder mapper, String entityName, boolean insertable) {
        String referencedEntityName = ((ToOne)value).getReferencedEntityName();
        IdMappingData idMapping = this.mainGenerator.getReferencedIdMappingData(entityName, referencedEntityName, propertyAuditingData, true);
        String lastPropertyPrefix = MappingTools.createToOneRelationPrefix(propertyAuditingData.getName());
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneRelation(propertyAuditingData.getName(), referencedEntityName, relMapper, insertable);
        PropertyData propertyData = propertyAuditingData.getPropertyData();
        mapper.addComposite(propertyData, new OneToOnePrimaryKeyJoinColumnMapper(entityName, referencedEntityName, propertyData));
    }
}

