/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.event;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.event.BaseEnversEventListener;
import org.hibernate.envers.synchronization.AuditProcess;
import org.hibernate.envers.synchronization.work.AddWorkUnit;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public class EnversPostInsertEventListenerImpl
extends BaseEnversEventListener
implements PostInsertEventListener {
    public EnversPostInsertEventListenerImpl(AuditConfiguration enversConfiguration) {
        super(enversConfiguration);
    }

    public void onPostInsert(PostInsertEvent event) {
        String entityName = event.getPersister().getEntityName();
        if (this.getAuditConfiguration().getEntCfg().isVersioned(entityName)) {
            this.checkIfTransactionInProgress((SessionImplementor)event.getSession());
            AuditProcess auditProcess = this.getAuditConfiguration().getSyncManager().get(event.getSession());
            AddWorkUnit workUnit = new AddWorkUnit((SessionImplementor)event.getSession(), event.getPersister().getEntityName(), this.getAuditConfiguration(), event.getId(), event.getPersister(), event.getState());
            auditProcess.addWorkUnit(workUnit);
            if (workUnit.containsWork()) {
                this.generateBidirectionalCollectionChangeWorkUnits(auditProcess, event.getPersister(), entityName, event.getState(), null, (SessionImplementor)event.getSession());
            }
        }
    }

    public boolean requiresPostCommitHanding(EntityPersister persister) {
        return this.getAuditConfiguration().getEntCfg().isVersioned(persister.getEntityName());
    }
}

