/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.strategy;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.GlobalConfiguration;
import org.hibernate.envers.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.entities.mapper.relation.MiddleComponentData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.synchronization.SessionCacheCleaner;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.EventType;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.property.Getter;
import org.hibernate.sql.Update;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class ValidityAuditStrategy
implements AuditStrategy {
    private static final Logger log = Logger.getLogger(ValidityAuditStrategy.class);
    private Getter revisionTimestampGetter = null;
    private final SessionCacheCleaner sessionCacheCleaner = new SessionCacheCleaner();

    @Override
    public void perform(Session session, String entityName, final AuditConfiguration auditCfg, final Serializable id, Object data, final Object revision) {
        AuditEntitiesConfiguration audEntitiesCfg = auditCfg.getAuditEntCfg();
        String auditedEntityName = audEntitiesCfg.getAuditEntityName(entityName);
        String revisionInfoEntityName = auditCfg.getAuditEntCfg().getRevisionInfoEntityName();
        final SessionImplementor sessionImplementor = (SessionImplementor)session;
        Dialect dialect = sessionImplementor.getFactory().getDialect();
        session.save(auditedEntityName, data);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, data);
        if (this.getRevisionType(auditCfg, data) != RevisionType.ADD) {
            Queryable productionEntityQueryable = this.getQueryable(entityName, sessionImplementor);
            final Queryable rootProductionEntityQueryable = this.getQueryable(productionEntityQueryable.getRootEntityName(), sessionImplementor);
            Queryable auditedEntityQueryable = this.getQueryable(auditedEntityName, sessionImplementor);
            final Queryable rootAuditedEntityQueryable = this.getQueryable(auditedEntityQueryable.getRootEntityName(), sessionImplementor);
            Queryable revisionInfoEntityQueryable = this.getQueryable(revisionInfoEntityName, sessionImplementor);
            String updateTableName = UnionSubclassEntityPersister.class.isInstance(rootProductionEntityQueryable) ? auditedEntityQueryable.getSubclassTableName(0) : rootAuditedEntityQueryable.getTableName();
            this.autoFlushIfRequired(sessionImplementor, rootAuditedEntityQueryable, revisionInfoEntityQueryable);
            final Type revisionInfoIdType = sessionImplementor.getFactory().getEntityPersister(revisionInfoEntityName).getIdentifierType();
            String revEndColumnName = rootAuditedEntityQueryable.toColumns(auditCfg.getAuditEntCfg().getRevisionEndFieldName())[0];
            final boolean isRevisionEndTimestampEnabled = auditCfg.getAuditEntCfg().isRevisionEndTimestampEnabled();
            Update update = new Update(dialect).setTableName(updateTableName);
            update.addColumn(revEndColumnName);
            if (isRevisionEndTimestampEnabled) {
                update.addColumn(rootAuditedEntityQueryable.toColumns(auditCfg.getAuditEntCfg().getRevisionEndTimestampFieldName())[0]);
            }
            update.addPrimaryKeyColumns(rootProductionEntityQueryable.getIdentifierColumnNames());
            update.addWhereColumn(rootAuditedEntityQueryable.toColumns(auditCfg.getAuditEntCfg().getRevisionNumberPath())[0], "<> ?");
            update.addWhereColumn(revEndColumnName, " is null");
            final String updateSql = update.toStatementString();
            int rowCount = (Integer)session.doReturningWork((ReturningWork)new ReturningWork<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Integer execute(Connection connection) throws SQLException {
                    PreparedStatement preparedStatement = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(updateSql);
                    try {
                        int index = 1;
                        Number revisionNumber = auditCfg.getRevisionInfoNumberReader().getRevisionNumber(revision);
                        revisionInfoIdType.nullSafeSet(preparedStatement, (Object)revisionNumber, index, sessionImplementor);
                        index += revisionInfoIdType.getColumnSpan((Mapping)sessionImplementor.getFactory());
                        if (isRevisionEndTimestampEnabled) {
                            Object revEndTimestampObj = ValidityAuditStrategy.this.revisionTimestampGetter.get(revision);
                            Date revisionEndTimestamp = ValidityAuditStrategy.this.convertRevEndTimestampToDate(revEndTimestampObj);
                            Type revEndTsType = rootAuditedEntityQueryable.getPropertyType(auditCfg.getAuditEntCfg().getRevisionEndTimestampFieldName());
                            revEndTsType.nullSafeSet(preparedStatement, (Object)revisionEndTimestamp, index, sessionImplementor);
                            index += revEndTsType.getColumnSpan((Mapping)sessionImplementor.getFactory());
                        }
                        Type idType = rootProductionEntityQueryable.getIdentifierType();
                        idType.nullSafeSet(preparedStatement, (Object)id, index, sessionImplementor);
                        Type revType = rootAuditedEntityQueryable.getPropertyType(auditCfg.getAuditEntCfg().getRevisionNumberPath());
                        revType.nullSafeSet(preparedStatement, (Object)revisionNumber, index += idType.getColumnSpan((Mapping)sessionImplementor.getFactory()), sessionImplementor);
                        Integer n = sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().getResultSetReturn().executeUpdate(preparedStatement);
                        return n;
                    }
                    finally {
                        sessionImplementor.getTransactionCoordinator().getJdbcCoordinator().release((Statement)preparedStatement);
                    }
                }
            });
            if (rowCount != 1) {
                throw new RuntimeException("Cannot update previous revision for entity " + auditedEntityName + " and id " + id);
            }
        }
    }

    private Queryable getQueryable(String entityName, SessionImplementor sessionImplementor) {
        return (Queryable)sessionImplementor.getFactory().getEntityPersister(entityName);
    }

    private void autoFlushIfRequired(SessionImplementor sessionImplementor, Queryable auditedEntityQueryable, Queryable revisionInfoEntityQueryable) {
        HashSet<String> querySpaces = new HashSet<String>();
        querySpaces.add(auditedEntityQueryable.getTableName());
        querySpaces.add(revisionInfoEntityQueryable.getTableName());
        AutoFlushEvent event = new AutoFlushEvent(querySpaces, (EventSource)sessionImplementor);
        Iterable listeners = ((EventListenerRegistry)sessionImplementor.getFactory().getServiceRegistry().getService(EventListenerRegistry.class)).getEventListenerGroup(EventType.AUTO_FLUSH).listeners();
        for (AutoFlushEventListener listener : listeners) {
            listener.onAutoFlush(event);
        }
    }

    @Override
    public void performCollectionChange(Session session, String entityName, String propertyName, AuditConfiguration auditCfg, PersistentCollectionChangeData persistentCollectionChangeData, Object revision) {
        CollectionType collectionPropertyType;
        QueryBuilder qb = new QueryBuilder(persistentCollectionChangeData.getEntityName(), "ee__");
        String originalIdPropName = auditCfg.getAuditEntCfg().getOriginalIdPropName();
        Map originalId = (Map)persistentCollectionChangeData.getData().get(originalIdPropName);
        String revisionFieldName = auditCfg.getAuditEntCfg().getRevisionFieldName();
        String revisionTypePropName = auditCfg.getAuditEntCfg().getRevisionTypePropName();
        for (Map.Entry originalIdEntry : originalId.entrySet()) {
            if (revisionFieldName.equals(originalIdEntry.getKey()) || revisionTypePropName.equals(originalIdEntry.getKey())) continue;
            qb.getRootParameters().addWhereWithParam(originalIdPropName + "." + (String)originalIdEntry.getKey(), true, "=", originalIdEntry.getValue());
        }
        SessionFactoryImplementor sessionFactory = ((SessionImplementor)session).getFactory();
        Type propertyType = sessionFactory.getEntityPersister(entityName).getPropertyType(propertyName);
        if (propertyType.isCollectionType() && (collectionPropertyType = (CollectionType)propertyType).getElementType(sessionFactory) instanceof ComponentType) {
            for (Map.Entry<String, Object> dataEntry : persistentCollectionChangeData.getData().entrySet()) {
                if (originalIdPropName.equals(dataEntry.getKey())) continue;
                qb.getRootParameters().addWhereWithParam(dataEntry.getKey(), true, "=", dataEntry.getValue());
            }
        }
        this.addEndRevisionNullRestriction(auditCfg, qb.getRootParameters());
        List l = qb.toQuery(session).setLockOptions(LockOptions.UPGRADE).list();
        if (l.size() > 0) {
            this.updateLastRevision(session, auditCfg, l, originalId, persistentCollectionChangeData.getEntityName(), revision);
        }
        session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, persistentCollectionChangeData.getData());
    }

    private void addEndRevisionNullRestriction(AuditConfiguration auditCfg, Parameters rootParameters) {
        rootParameters.addWhere(auditCfg.getAuditEntCfg().getRevisionEndFieldName(), true, "is", "null", false);
    }

    @Override
    public void addEntityAtRevisionRestriction(GlobalConfiguration globalCfg, QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData idData, String revisionPropertyPath, String originalIdPropertyName, String alias1, String alias2) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    @Override
    public void addAssociationAtRevisionRestriction(QueryBuilder rootQueryBuilder, String revisionProperty, String revisionEndProperty, boolean addAlias, MiddleIdData referencingIdData, String versionsMiddleEntityName, String eeOriginalIdPropertyPath, String revisionPropertyPath, String originalIdPropertyName, String alias1, MiddleComponentData ... componentDatas) {
        Parameters rootParameters = rootQueryBuilder.getRootParameters();
        this.addRevisionRestriction(rootParameters, revisionProperty, revisionEndProperty, addAlias);
    }

    public void setRevisionTimestampGetter(Getter revisionTimestampGetter) {
        this.revisionTimestampGetter = revisionTimestampGetter;
    }

    private void addRevisionRestriction(Parameters rootParameters, String revisionProperty, String revisionEndProperty, boolean addAlias) {
        Parameters subParm = rootParameters.addSubParameters("or");
        rootParameters.addWhereWithNamedParam(revisionProperty, addAlias, "<=", "revision");
        subParm.addWhereWithNamedParam(revisionEndProperty + ".id", addAlias, ">", "revision");
        subParm.addWhere(revisionEndProperty, addAlias, "is", "null", false);
    }

    private RevisionType getRevisionType(AuditConfiguration auditCfg, Object data) {
        return (RevisionType)((Object)((Map)data).get(auditCfg.getAuditEntCfg().getRevisionTypePropName()));
    }

    private void updateLastRevision(Session session, AuditConfiguration auditCfg, List<Object> l, Object id, String auditedEntityName, Object revision) {
        Object previousData;
        if (l.size() == 1) {
            previousData = l.get(0);
            String revisionEndFieldName = auditCfg.getAuditEntCfg().getRevisionEndFieldName();
            ((Map)previousData).put(revisionEndFieldName, revision);
            if (auditCfg.getAuditEntCfg().isRevisionEndTimestampEnabled()) {
                String revEndTimestampFieldName = auditCfg.getAuditEntCfg().getRevisionEndTimestampFieldName();
                Object revEndTimestampObj = this.revisionTimestampGetter.get(revision);
                Date revisionEndTimestamp = this.convertRevEndTimestampToDate(revEndTimestampObj);
                ((Map)previousData).put(revEndTimestampFieldName, revisionEndTimestamp);
            }
        } else {
            throw new RuntimeException("Cannot find previous revision for entity " + auditedEntityName + " and id " + id);
        }
        session.save(auditedEntityName, previousData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, previousData);
    }

    private Date convertRevEndTimestampToDate(Object revEndTimestampObj) {
        if (revEndTimestampObj instanceof Date) {
            return (Date)revEndTimestampObj;
        }
        return new Date((Long)revEndTimestampObj);
    }
}

