/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools;

import java.util.Map;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.tools.Pair;
import org.hibernate.internal.util.collections.ConcurrentReferenceHashMap;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;

public abstract class ReflectionTools {
    private static final Map<Pair<Class, String>, Getter> GETTER_CACHE = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);
    private static final Map<Pair<Class, String>, Setter> SETTER_CACHE = new ConcurrentReferenceHashMap(10, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT);

    private static PropertyAccessor getAccessor(String accessorType) {
        return PropertyAccessorFactory.getPropertyAccessor((String)accessorType);
    }

    public static Getter getGetter(Class cls, PropertyData propertyData) {
        return ReflectionTools.getGetter(cls, propertyData.getBeanName(), propertyData.getAccessType());
    }

    public static Getter getGetter(Class cls, String propertyName, String accessorType) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Getter value = GETTER_CACHE.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessor(accessorType).getGetter(cls, propertyName);
            GETTER_CACHE.put(key, value);
        }
        return value;
    }

    public static Setter getSetter(Class cls, PropertyData propertyData) {
        return ReflectionTools.getSetter(cls, propertyData.getBeanName(), propertyData.getAccessType());
    }

    private static Setter getSetter(Class cls, String propertyName, String accessorType) {
        Pair<Class, String> key = Pair.make(cls, propertyName);
        Setter value = SETTER_CACHE.get(key);
        if (value == null) {
            value = ReflectionTools.getAccessor(accessorType).getSetter(cls, propertyName);
            SETTER_CACHE.put(key, value);
        }
        return value;
    }

    public static XProperty getProperty(XClass clazz, String propertyName) {
        XProperty property = ReflectionTools.getProperty(clazz, propertyName, "field");
        if (property == null) {
            property = ReflectionTools.getProperty(clazz, propertyName, "property");
        }
        return property;
    }

    public static XProperty getProperty(XClass clazz, String propertyName, String accessType) {
        for (XProperty property : clazz.getDeclaredProperties(accessType)) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static <T> Class<T> loadClass(String name, ClassLoaderService classLoaderService) throws ClassLoadingException {
        try {
            if (classLoaderService != null) {
                return classLoaderService.classForName(name);
            }
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            throw new ClassLoadingException("Unable to load class [" + name + "]", (Throwable)e);
        }
    }
}

