/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.boot.internal;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.configuration.internal.EntitiesConfigurator;
import org.hibernate.envers.configuration.internal.GlobalConfiguration;
import org.hibernate.envers.configuration.internal.MappingCollector;
import org.hibernate.envers.configuration.internal.RevisionInfoConfiguration;
import org.hibernate.envers.configuration.internal.RevisionInfoConfigurationResult;
import org.hibernate.envers.internal.entities.EntitiesConfigurations;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.ModifiedEntityNamesReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoNumberReader;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoQueryCreator;
import org.hibernate.envers.internal.synchronization.AuditProcessManager;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.strategy.AuditStrategy;
import org.hibernate.envers.strategy.ValidityAuditStrategy;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.property.Getter;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.jboss.logging.Logger;

public class EnversServiceImpl
implements EnversService,
Configurable,
Stoppable {
    private static final Logger log = Logger.getLogger(EnversServiceImpl.class);
    private boolean integrationEnabled;
    private boolean initialized;
    private ServiceRegistry serviceRegistry;
    private ClassLoaderService classLoaderService;
    private GlobalConfiguration globalConfiguration;
    private AuditEntitiesConfiguration auditEntitiesConfiguration;
    private AuditProcessManager auditProcessManager;
    private AuditStrategy auditStrategy;
    private EntitiesConfigurations entitiesConfigurations;
    private RevisionInfoQueryCreator revisionInfoQueryCreator;
    private RevisionInfoNumberReader revisionInfoNumberReader;
    private ModifiedEntityNamesReader modifiedEntityNamesReader;

    public void configure(Map configurationValues) {
        boolean legacySetting = ConfigurationHelper.getBoolean((String)"hibernate.listeners.envers.autoRegister", (Map)configurationValues, (boolean)true);
        this.integrationEnabled = ConfigurationHelper.getBoolean((String)"hibernate.integration.envers.enabled", (Map)configurationValues, (boolean)legacySetting);
        log.infof("Envers integration enabled? : %s", (Object)this.integrationEnabled);
    }

    @Override
    public boolean isEnabled() {
        return this.integrationEnabled;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize(MetadataImplementor metadata, MappingCollector mappingCollector) {
        if (this.initialized) {
            throw new UnsupportedOperationException("EnversService#initialize should be called only once");
        }
        this.initialized = true;
        this.serviceRegistry = metadata.getMetadataBuildingOptions().getServiceRegistry();
        this.classLoaderService = (ClassLoaderService)this.serviceRegistry.getService(ClassLoaderService.class);
        this.doInitialize(metadata, mappingCollector, this.serviceRegistry, this.classLoaderService);
    }

    private void doInitialize(MetadataImplementor metadata, MappingCollector mappingCollector, ServiceRegistry serviceRegistry, ClassLoaderService classLoaderService) {
        ConfigurationService cfgService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)cfgService.getSettings());
        this.globalConfiguration = new GlobalConfiguration(properties, classLoaderService);
        ReflectionManager reflectionManager = metadata.getMetadataBuildingOptions().getReflectionManager();
        RevisionInfoConfiguration revInfoCfg = new RevisionInfoConfiguration(this.globalConfiguration);
        RevisionInfoConfigurationResult revInfoCfgResult = revInfoCfg.configure(metadata, reflectionManager);
        this.auditEntitiesConfiguration = new AuditEntitiesConfiguration(properties, revInfoCfgResult.getRevisionInfoEntityName());
        this.auditProcessManager = new AuditProcessManager(revInfoCfgResult.getRevisionInfoGenerator());
        this.revisionInfoQueryCreator = revInfoCfgResult.getRevisionInfoQueryCreator();
        this.revisionInfoNumberReader = revInfoCfgResult.getRevisionInfoNumberReader();
        this.modifiedEntityNamesReader = revInfoCfgResult.getModifiedEntityNamesReader();
        this.auditStrategy = EnversServiceImpl.initializeAuditStrategy(this.auditEntitiesConfiguration.getAuditStrategyName(), revInfoCfgResult.getRevisionInfoClass(), revInfoCfgResult.getRevisionInfoTimestampData(), classLoaderService);
        this.entitiesConfigurations = new EntitiesConfigurator().configure(metadata, serviceRegistry, reflectionManager, mappingCollector, this.globalConfiguration, this.auditEntitiesConfiguration, this.auditStrategy, revInfoCfgResult.getRevisionInfoXmlMapping(), revInfoCfgResult.getRevisionInfoRelationMapping());
    }

    private static AuditStrategy initializeAuditStrategy(String auditStrategyName, Class<?> revisionInfoClass, PropertyData revisionInfoTimestampData, ClassLoaderService classLoaderService) {
        AuditStrategy strategy;
        try {
            Class<?> auditStrategyClass = EnversServiceImpl.loadClass(auditStrategyName, classLoaderService);
            strategy = (AuditStrategy)ReflectHelper.getDefaultConstructor(auditStrategyClass).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MappingException(String.format("Unable to create AuditStrategy [%s] instance.", auditStrategyName), (Throwable)e);
        }
        if (strategy instanceof ValidityAuditStrategy) {
            Getter revisionTimestampGetter = ReflectionTools.getGetter(revisionInfoClass, revisionInfoTimestampData);
            ((ValidityAuditStrategy)strategy).setRevisionTimestampGetter(revisionTimestampGetter);
        }
        return strategy;
    }

    private static Class<?> loadClass(String auditStrategyName, ClassLoaderService classLoaderService) {
        try {
            return EnversServiceImpl.class.getClassLoader().loadClass(auditStrategyName);
        }
        catch (Exception e) {
            return ReflectionTools.loadClass(auditStrategyName, classLoaderService);
        }
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.globalConfiguration;
    }

    @Override
    public AuditEntitiesConfiguration getAuditEntitiesConfiguration() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.auditEntitiesConfiguration;
    }

    @Override
    public AuditProcessManager getAuditProcessManager() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.auditProcessManager;
    }

    @Override
    public AuditStrategy getAuditStrategy() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.auditStrategy;
    }

    @Override
    public EntitiesConfigurations getEntitiesConfigurations() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.entitiesConfigurations;
    }

    @Override
    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.revisionInfoQueryCreator;
    }

    @Override
    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.revisionInfoNumberReader;
    }

    @Override
    public ModifiedEntityNamesReader getModifiedEntityNamesReader() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.modifiedEntityNamesReader;
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        if (!this.initialized) {
            throw new IllegalStateException("Service is not yet initialized");
        }
        return this.classLoaderService;
    }

    public void stop() {
    }
}

