/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.synchronization;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.synchronization.EntityChangeNotifier;
import org.hibernate.envers.internal.synchronization.work.AuditWorkUnit;
import org.hibernate.envers.tools.Pair;

public class AuditProcess
implements BeforeTransactionCompletionProcess {
    private final RevisionInfoGenerator revisionInfoGenerator;
    private final SessionImplementor session;
    private final LinkedList<AuditWorkUnit> workUnits;
    private final Queue<AuditWorkUnit> undoQueue;
    private final Map<Pair<String, Object>, AuditWorkUnit> usedIds;
    private final EntityChangeNotifier entityChangeNotifier;
    private Object revisionData;

    public AuditProcess(RevisionInfoGenerator revisionInfoGenerator, SessionImplementor session) {
        this.revisionInfoGenerator = revisionInfoGenerator;
        this.session = session;
        this.workUnits = new LinkedList();
        this.undoQueue = new LinkedList<AuditWorkUnit>();
        this.usedIds = new HashMap<Pair<String, Object>, AuditWorkUnit>();
        this.entityChangeNotifier = new EntityChangeNotifier(revisionInfoGenerator, session);
    }

    private void removeWorkUnit(AuditWorkUnit vwu) {
        this.workUnits.remove(vwu);
        if (vwu.isPerformed()) {
            this.undoQueue.offer(vwu);
        }
    }

    public void addWorkUnit(AuditWorkUnit vwu) {
        if (vwu.containsWork()) {
            Serializable entityId = vwu.getEntityId();
            if (entityId == null) {
                this.workUnits.offer(vwu);
            } else {
                String entityName = vwu.getEntityName();
                Pair<String, Serializable> usedIdsKey = Pair.make(entityName, entityId);
                if (this.usedIds.containsKey(usedIdsKey)) {
                    AuditWorkUnit other = this.usedIds.get(usedIdsKey);
                    AuditWorkUnit result = vwu.dispatch(other);
                    if (result != other) {
                        this.removeWorkUnit(other);
                        if (result != null) {
                            this.usedIds.put(usedIdsKey, result);
                            this.workUnits.offer(result);
                        }
                    }
                } else {
                    this.usedIds.put(usedIdsKey, vwu);
                    this.workUnits.offer(vwu);
                }
            }
        }
    }

    private void executeInSession(Session session) {
        AuditWorkUnit vwu;
        Object currentRevisionData = this.getCurrentRevisionData(session, true);
        while ((vwu = this.undoQueue.poll()) != null) {
            vwu.undo(session);
        }
        while ((vwu = this.workUnits.poll()) != null) {
            vwu.perform(session, this.revisionData);
            this.entityChangeNotifier.entityChanged(session, currentRevisionData, vwu);
        }
    }

    public Object getCurrentRevisionData(Session session, boolean persist) {
        if (this.revisionData == null) {
            this.revisionData = this.revisionInfoGenerator.generate();
        }
        if (!session.contains(this.revisionData) && persist) {
            this.revisionInfoGenerator.saveRevisionData(session, this.revisionData);
        }
        return this.revisionData;
    }

    public void doBeforeTransactionCompletion(SessionImplementor session) {
        if (this.workUnits.size() == 0 && this.undoQueue.size() == 0) {
            return;
        }
        if (FlushMode.isManualFlushMode((FlushMode)session.getFlushMode())) {
            Session temporarySession = null;
            try {
                temporarySession = ((Session)session).sessionWithOptions().transactionContext().autoClose(false).connectionReleaseMode(ConnectionReleaseMode.AFTER_TRANSACTION).openSession();
                this.executeInSession(temporarySession);
                temporarySession.flush();
            }
            finally {
                if (temporarySession != null) {
                    temporarySession.close();
                }
            }
        } else {
            this.executeInSession((Session)session);
            session.flush();
        }
    }
}

