/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;

public class PropertyAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;
    private String otherPropertyName;
    private String op;

    public PropertyAuditExpression(PropertyNameGetter propertyNameGetter, String otherPropertyName, String op) {
        this.propertyNameGetter = propertyNameGetter;
        this.otherPropertyName = otherPropertyName;
        this.op = op;
    }

    @Override
    public void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, propertyName);
        CriteriaTools.checkPropertyNotARelation(enversService, entityName, this.otherPropertyName);
        parameters.addWhere(propertyName, this.op, this.otherPropertyName);
    }
}

