/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.revisioninfo;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.envers.EntityTrackingRevisionListener;
import org.hibernate.envers.RevisionListener;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.revisioninfo.RevisionInfoGenerator;
import org.hibernate.envers.internal.synchronization.SessionCacheCleaner;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.service.ServiceRegistry;

public class DefaultRevisionInfoGenerator
implements RevisionInfoGenerator {
    private final String revisionInfoEntityName;
    private final RevisionListener listener;
    private final Setter revisionTimestampSetter;
    private final boolean timestampAsDate;
    private final Constructor<?> revisionInfoClassConstructor;
    private final SessionCacheCleaner sessionCacheCleaner;

    public DefaultRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, PropertyData revisionInfoTimestampData, boolean timestampAsDate, ServiceRegistry serviceRegistry) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.timestampAsDate = timestampAsDate;
        this.revisionInfoClassConstructor = ReflectHelper.getDefaultConstructor(revisionInfoClass);
        this.revisionTimestampSetter = ReflectionTools.getSetter(revisionInfoClass, revisionInfoTimestampData, serviceRegistry);
        if (!listenerClass.equals(RevisionListener.class)) {
            try {
                this.listener = (RevisionListener)ReflectHelper.getDefaultConstructor(listenerClass).newInstance(new Object[0]);
            }
            catch (InstantiationException e) {
                throw new MappingException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new MappingException((Throwable)e);
            }
        } else {
            this.listener = null;
        }
        this.sessionCacheCleaner = new SessionCacheCleaner();
    }

    @Override
    public void saveRevisionData(Session session, Object revisionData) {
        session.save(this.revisionInfoEntityName, revisionData);
        this.sessionCacheCleaner.scheduleAuditDataRemoval(session, revisionData);
    }

    @Override
    public Object generate() {
        Object revisionInfo;
        try {
            revisionInfo = this.revisionInfoClassConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        long timestamp = System.currentTimeMillis();
        this.revisionTimestampSetter.set(revisionInfo, (Object)(this.timestampAsDate ? new Date(timestamp) : Long.valueOf(timestamp)), null);
        if (this.listener != null) {
            this.listener.newRevision(revisionInfo);
        }
        return revisionInfo;
    }

    @Override
    public void entityChanged(Class entityClass, String entityName, Serializable entityId, RevisionType revisionType, Object revisionInfo) {
        if (this.listener instanceof EntityTrackingRevisionListener) {
            ((EntityTrackingRevisionListener)this.listener).entityChanged(entityClass, entityName, entityId, revisionType, revisionInfo);
        }
    }
}

