/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.ComponentPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.CompositeMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.ExtendedPropertyMapper;
import org.hibernate.envers.internal.entities.mapper.PersistentCollectionChangeData;
import org.hibernate.envers.internal.entities.mapper.PropertyMapper;
import org.hibernate.envers.internal.entities.mapper.SinglePropertyMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.MappingTools;
import org.hibernate.envers.internal.tools.ReflectionTools;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.envers.tools.Pair;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.service.ServiceRegistry;

public class MultiPropertyMapper
implements ExtendedPropertyMapper {
    protected final Map<PropertyData, PropertyMapper> properties = Tools.newHashMap();
    private final Map<String, PropertyData> propertyDatas = Tools.newHashMap();

    @Override
    public void add(PropertyData propertyData) {
        SinglePropertyMapper single = new SinglePropertyMapper();
        single.add(propertyData);
        this.properties.put(propertyData, single);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    @Override
    public CompositeMapperBuilder addComponent(PropertyData propertyData, Class componentClass) {
        if (this.properties.get(propertyData) != null) {
            return (CompositeMapperBuilder)((Object)this.properties.get(propertyData));
        }
        ComponentPropertyMapper componentMapperBuilder = new ComponentPropertyMapper(propertyData, componentClass);
        this.addComposite(propertyData, componentMapperBuilder);
        return componentMapperBuilder;
    }

    @Override
    public void addComposite(PropertyData propertyData, PropertyMapper propertyMapper) {
        this.properties.put(propertyData, propertyMapper);
        this.propertyDatas.put(propertyData.getName(), propertyData);
    }

    protected Object getAtIndexOrNull(Object[] array, int index) {
        return array == null ? null : array[index];
    }

    @Override
    public boolean map(SessionImplementor session, Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean ret = false;
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (!this.propertyDatas.containsKey(propertyName)) continue;
            PropertyMapper propertyMapper = this.properties.get(this.propertyDatas.get(propertyName));
            Object newObj = this.getAtIndexOrNull(newState, i);
            Object oldObj = this.getAtIndexOrNull(oldState, i);
            ret |= propertyMapper.mapToMapFromEntity(session, data, newObj, oldObj);
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj, oldObj);
        }
        return ret;
    }

    @Override
    public boolean mapToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        boolean ret = false;
        for (Map.Entry<PropertyData, PropertyMapper> entry : this.properties.entrySet()) {
            Getter getter;
            PropertyData propertyData = entry.getKey();
            PropertyMapper propertyMapper = entry.getValue();
            if (propertyData.isSynthetic()) continue;
            if (newObj != null) {
                getter = ReflectionTools.getGetter(newObj.getClass(), propertyData, (ServiceRegistry)session.getFactory().getServiceRegistry());
            } else if (oldObj != null) {
                getter = ReflectionTools.getGetter(oldObj.getClass(), propertyData, (ServiceRegistry)session.getFactory().getServiceRegistry());
            } else {
                return false;
            }
            ret |= propertyMapper.mapToMapFromEntity(session, data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
        }
        return ret;
    }

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
        for (Map.Entry<PropertyData, PropertyMapper> entry : this.properties.entrySet()) {
            Getter getter;
            PropertyData propertyData = entry.getKey();
            PropertyMapper propertyMapper = entry.getValue();
            if (propertyData.isSynthetic()) continue;
            if (newObj != null) {
                getter = ReflectionTools.getGetter(newObj.getClass(), propertyData, (ServiceRegistry)session.getFactory().getServiceRegistry());
            } else if (oldObj != null) {
                getter = ReflectionTools.getGetter(oldObj.getClass(), propertyData, (ServiceRegistry)session.getFactory().getServiceRegistry());
            } else {
                return;
            }
            propertyMapper.mapModifiedFlagsToMapFromEntity(session, data, newObj == null ? null : getter.get(newObj), oldObj == null ? null : getter.get(oldObj));
        }
    }

    @Override
    public void mapToEntityFromMap(EnversService enversService, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        for (PropertyMapper mapper : this.properties.values()) {
            mapper.mapToEntityFromMap(enversService, obj, data, primaryKey, versionsReader, revision);
        }
    }

    private Pair<PropertyMapper, String> getMapperAndDelegatePropName(String referencingPropertyName) {
        String delegatePropertyName;
        int dotIndex = referencingPropertyName.indexOf(46);
        if (dotIndex != -1) {
            String componentName = referencingPropertyName.substring(0, dotIndex);
            String propertyInComponentName = MappingTools.createComponentPrefix(componentName) + referencingPropertyName.substring(dotIndex + 1);
            referencingPropertyName = componentName;
            delegatePropertyName = propertyInComponentName;
        } else {
            delegatePropertyName = referencingPropertyName;
        }
        return Pair.make(this.properties.get(this.propertyDatas.get(referencingPropertyName)), delegatePropertyName);
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        Pair<PropertyMapper, String> pair = this.getMapperAndDelegatePropName(collectionPropertyName);
        PropertyMapper mapper = pair.getFirst();
        if (mapper != null) {
            mapper.mapModifiedFlagsToMapForCollectionChange(pair.getSecond(), data);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(SessionImplementor session, String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        Pair<PropertyMapper, String> pair = this.getMapperAndDelegatePropName(referencingPropertyName);
        PropertyMapper mapper = pair.getFirst();
        if (mapper != null) {
            return mapper.mapCollectionChanges(session, pair.getSecond(), newColl, oldColl, id);
        }
        return null;
    }

    @Override
    public Map<PropertyData, PropertyMapper> getProperties() {
        return this.properties;
    }

    public Map<String, PropertyData> getPropertyDatas() {
        return this.propertyDatas;
    }
}

