/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation.query;

import java.util.Collections;
import java.util.Map;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.internal.AuditEntitiesConfiguration;
import org.hibernate.envers.internal.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.internal.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.internal.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.query.Query;

public abstract class AbstractRelationQueryGenerator
implements RelationQueryGenerator {
    protected final AuditEntitiesConfiguration verEntCfg;
    protected final MiddleIdData referencingIdData;
    protected final boolean revisionTypeInId;

    protected AbstractRelationQueryGenerator(AuditEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, boolean revisionTypeInId) {
        this.verEntCfg = verEntCfg;
        this.referencingIdData = referencingIdData;
        this.revisionTypeInId = revisionTypeInId;
    }

    protected abstract String getQueryString();

    protected abstract String getQueryRemovedString();

    @Override
    public Query getQuery(AuditReaderImplementor versionsReader, Object primaryKey, Number revision, boolean removed) {
        Query query = versionsReader.getSession().createQuery(removed ? this.getQueryRemovedString() : this.getQueryString());
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        query.setParameter("revision", (Object)revision);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }

    protected String getRevisionTypePath() {
        return this.revisionTypeInId ? this.verEntCfg.getOriginalIdPropName() + "." + this.verEntCfg.getRevisionTypePropName() : this.verEntCfg.getRevisionTypePropName();
    }

    protected String queryToString(QueryBuilder query) {
        return this.queryToString(query, Collections.emptyMap());
    }

    protected String queryToString(QueryBuilder query, Map<String, Object> queryParamValues) {
        StringBuilder sb = new StringBuilder();
        query.build(sb, queryParamValues);
        return sb.toString();
    }
}

