/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.configuration.internal.metadata;

import java.util.Properties;
import org.dom4j.Element;
import org.hibernate.boot.Metadata;
import org.hibernate.envers.configuration.internal.metadata.AuditMetadataGenerator;
import org.hibernate.envers.configuration.internal.metadata.MetadataTools;
import org.hibernate.envers.configuration.internal.metadata.reader.PropertyAuditingData;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.SimpleMapperBuilder;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.type.BasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.EnumType;
import org.hibernate.type.Type;

public final class BasicMetadataGenerator {
    private final Metadata metadata;

    public BasicMetadataGenerator(AuditMetadataGenerator mainGenerator) {
        this.metadata = mainGenerator.getMetadata();
    }

    boolean addBasic(Element parent, PropertyAuditingData propertyAuditingData, Value value, SimpleMapperBuilder mapper, boolean insertable, boolean key) {
        if (value.getType() instanceof BasicType) {
            if (parent != null) {
                Element propMapping = this.buildProperty(parent, propertyAuditingData, value, insertable, key);
                if (this.isAddNestedType(value)) {
                    this.applyNestedType((SimpleValue)value, propMapping);
                }
            }
            if (mapper != null) {
                PropertyData propertyData = propertyAuditingData.resolvePropertyData(value.getType());
                mapper.add(propertyData);
            }
            return true;
        }
        return false;
    }

    private void mapEnumerationType(Element parent, Type type, Properties parameters) {
        if (parameters.getProperty("enumClass") != null) {
            parent.addElement("param").addAttribute("name", "enumClass").setText(parameters.getProperty("enumClass"));
        } else {
            parent.addElement("param").addAttribute("name", "enumClass").setText(type.getReturnedClass().getName());
        }
        if (parameters.getProperty("useNamed") != null) {
            parent.addElement("param").addAttribute("name", "useNamed").setText(parameters.getProperty("useNamed"));
        } else {
            parent.addElement("param").addAttribute("name", "useNamed").setText("" + !((EnumType)((CustomType)type).getUserType()).isOrdinal());
        }
    }

    private boolean isAddNestedType(Value value) {
        return value instanceof SimpleValue && ((SimpleValue)value).getTypeParameters() != null;
    }

    private Element buildProperty(Element parent, PropertyAuditingData propertyAuditingData, Value value, boolean insertable, boolean key) {
        Element propMapping = MetadataTools.addProperty(parent, propertyAuditingData.getName(), this.isAddNestedType(value) ? null : this.getBasicTypeName(value.getType()), propertyAuditingData.isForceInsertable() || insertable, key);
        MetadataTools.addColumns(propMapping, value.getColumnIterator(), this.metadata);
        return propMapping;
    }

    private void applyNestedType(SimpleValue value, Element propertyMapping) {
        Properties typeParameters = value.getTypeParameters();
        Element typeMapping = propertyMapping.addElement("type");
        String typeName = this.getBasicTypeName(value.getType());
        typeMapping.addAttribute("name", typeName);
        if (this.isEnumType(value.getType(), typeName)) {
            this.mapEnumerationType(typeMapping, value.getType(), typeParameters);
        } else {
            for (Object object : typeParameters.keySet()) {
                String keyType = (String)object;
                String property = typeParameters.getProperty(keyType);
                if (property == null) continue;
                typeMapping.addElement("param").addAttribute("name", keyType).setText(property);
            }
        }
    }

    private String getBasicTypeName(Type type) {
        String typeName = type.getName();
        if (typeName == null) {
            typeName = type.getClass().getName();
        }
        return typeName;
    }

    private boolean isEnumType(Type type, String typeName) {
        CustomType customType;
        if (CustomType.class.isInstance(type) && EnumType.class.isInstance((customType = (CustomType)type).getUserType())) {
            return true;
        }
        return EnumType.class.getName().equals(typeName);
    }
}

