/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class BaseRegion
implements Region {
    private static final Log log = LogFactory.getLog(BaseRegion.class);
    private final String name;
    private final AdvancedCache regionClearCache;
    private final TransactionManager tm;
    private final Object invalidationMutex = new Object();
    private final AtomicReference<InvalidateState> invalidateState = new AtomicReference<InvalidateState>(InvalidateState.VALID);
    private final RegionFactory factory;
    protected final AdvancedCache cache;

    public BaseRegion(AdvancedCache cache, String name, RegionFactory factory) {
        this.cache = cache;
        this.name = name;
        this.tm = cache.getTransactionManager();
        this.factory = factory;
        this.regionClearCache = cache.withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
    }

    public String getName() {
        return this.name;
    }

    public long getElementCountInMemory() {
        if (this.checkValid()) {
            return this.cache.size();
        }
        return 0L;
    }

    public long getElementCountOnDisk() {
        return -1L;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public int getTimeout() {
        return 600;
    }

    public long nextTimestamp() {
        return this.factory.nextTimestamp();
    }

    public Map toMap() {
        if (this.checkValid()) {
            return this.cache;
        }
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws CacheException {
        try {
            this.cache.stop();
        }
        finally {
            this.cache.removeListener((Object)this);
        }
    }

    public boolean contains(Object key) {
        return this.checkValid() && this.cache.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkValid() {
        boolean valid = this.isValid();
        if (!valid) {
            Object object = this.invalidationMutex;
            synchronized (object) {
                if (this.invalidateState.compareAndSet(InvalidateState.INVALID, InvalidateState.CLEARING)) {
                    Transaction tx = this.suspend();
                    try {
                        Caches.withinTx(this.cache, new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                BaseRegion.this.regionClearCache.clear();
                                return null;
                            }
                        });
                        this.invalidateState.compareAndSet(InvalidateState.CLEARING, InvalidateState.VALID);
                    }
                    catch (Exception e) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("Could not invalidate region: " + e.getLocalizedMessage()));
                        }
                    }
                    finally {
                        this.resume(tx);
                    }
                }
            }
            valid = this.isValid();
        }
        return valid;
    }

    protected boolean isValid() {
        return this.invalidateState.get() == InvalidateState.VALID;
    }

    public Transaction suspend() {
        Transaction tx = null;
        try {
            if (this.tm != null) {
                tx = this.tm.suspend();
            }
        }
        catch (SystemException se) {
            throw new CacheException("Could not suspend transaction", (Throwable)se);
        }
        return tx;
    }

    public void resume(Transaction tx) {
        try {
            if (tx != null) {
                this.tm.resume(tx);
            }
        }
        catch (Exception e) {
            throw new CacheException("Could not resume transaction", (Throwable)e);
        }
    }

    public void invalidateRegion() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Invalidate region: " + this.name));
        }
        this.invalidateState.set(InvalidateState.INVALID);
    }

    public TransactionManager getTransactionManager() {
        return this.tm;
    }

    public boolean isTransactionAware() {
        return this.tm != null;
    }

    public AdvancedCache getCache() {
        return this.cache;
    }

    private static enum InvalidateState {
        INVALID,
        CLEARING,
        VALID;

    }
}

