/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.query;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.hibernate.HibernateException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.TransactionConfiguration;
import org.infinispan.context.Flag;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class QueryResultsRegionImpl
extends BaseTransactionalDataRegion
implements QueryResultsRegion {
    private static final Log log = LogFactory.getLog(QueryResultsRegionImpl.class);
    private final AdvancedCache evictCache;
    private final AdvancedCache putCache;
    private final AdvancedCache getCache;
    private final ConcurrentMap<SessionImplementor, Map> transactionContext = new ConcurrentHashMap<SessionImplementor, Map>();
    private final boolean putCacheRequiresTransaction;

    public QueryResultsRegionImpl(AdvancedCache cache, String name, RegionFactory factory) {
        super(cache, name, null, factory, null);
        boolean localOnly = Caches.isInvalidationCache(cache);
        this.evictCache = localOnly ? Caches.localCache(cache) : cache;
        this.putCache = localOnly ? Caches.failSilentWriteCache(cache, Flag.CACHE_MODE_LOCAL) : Caches.failSilentWriteCache(cache);
        this.getCache = Caches.failSilentReadCache(cache);
        TransactionConfiguration transactionConfiguration = this.putCache.getCacheConfiguration().transaction();
        boolean transactional = transactionConfiguration.transactionMode() != TransactionMode.NON_TRANSACTIONAL;
        boolean bl = this.putCacheRequiresTransaction = transactional && !transactionConfiguration.autoCommit();
        if (transactional) {
            log.warn((Object)"Use non-transactional query caches for best performance!");
        }
    }

    public void evict(Object key) throws CacheException {
        for (Map map : this.transactionContext.values()) {
            map.remove(key);
        }
        this.evictCache.remove(key);
    }

    public void evictAll() throws CacheException {
        this.transactionContext.clear();
        Transaction tx = this.suspend();
        try {
            this.invalidateRegion();
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.resume(tx);
        }
    }

    public Object get(SessionImplementor session, Object key) throws CacheException {
        Map map;
        boolean skipCacheStore = false;
        if (!this.isValid()) {
            skipCacheStore = true;
        }
        if (!this.checkValid()) {
            return null;
        }
        Object result = skipCacheStore ? this.getCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).get(key) : this.getCache.get(key);
        if (result == null && (map = (Map)this.transactionContext.get(session)) != null) {
            result = map.get(key);
        }
        return result;
    }

    public void put(SessionImplementor session, Object key, Object value) throws CacheException {
        if (this.checkValid()) {
            TransactionCoordinator tc = session.getTransactionCoordinator();
            if (tc != null && tc.isJoined()) {
                tc.getLocalSynchronizations().registerSynchronization((Synchronization)new PostTransactionQueryUpdate(tc, session, key, value));
                HashMap<Object, Object> map = (HashMap<Object, Object>)this.transactionContext.get(session);
                if (map == null) {
                    map = new HashMap<Object, Object>();
                    this.transactionContext.put(session, map);
                }
                map.put(key, value);
                return;
            }
            this.putCache.put(key, value);
        }
    }

    private class PostTransactionQueryUpdate
    implements Synchronization {
        private final TransactionCoordinator tc;
        private final SessionImplementor session;
        private final Object key;
        private final Object value;

        public PostTransactionQueryUpdate(TransactionCoordinator tc, SessionImplementor session, Object key, Object value) {
            this.tc = tc;
            this.session = session;
            this.key = key;
            this.value = value;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            QueryResultsRegionImpl.this.transactionContext.remove(this.session);
            switch (status) {
                case 3: 
                case 8: {
                    try {
                        this.tc.createIsolationDelegate().delegateWork((WorkExecutorVisitable)new WorkExecutorVisitable<Void>(){

                            public Void accept(WorkExecutor<Void> executor, Connection connection) throws SQLException {
                                QueryResultsRegionImpl.this.putCache.put(PostTransactionQueryUpdate.this.key, PostTransactionQueryUpdate.this.value);
                                return null;
                            }
                        }, QueryResultsRegionImpl.this.putCacheRequiresTransaction);
                    }
                    catch (HibernateException e) {
                        if (!log.isTraceEnabled()) break;
                        log.trace((Object)"Exception during query cache update", (Throwable)e);
                    }
                    break;
                }
            }
        }
    }
}

