/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Arrays;
import java.util.Set;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.context.Flag;
import org.infinispan.notifications.cachelistener.CacheNotifier;

public class BeginInvalidationCommand
extends InvalidateCommand {
    private Object sessionTransactionId;

    public BeginInvalidationCommand() {
    }

    public BeginInvalidationCommand(CacheNotifier notifier, Set<Flag> flags, CommandInvocationId commandInvocationId, Object[] keys, Object sessionTransactionId) {
        super(notifier, flags, commandInvocationId, keys);
        this.sessionTransactionId = sessionTransactionId;
    }

    public Object getSessionTransactionId() {
        return this.sessionTransactionId;
    }

    public Object[] getParameters() {
        if (this.keys == null || this.keys.length == 0) {
            return new Object[]{this.flags, this.sessionTransactionId, this.commandInvocationId, 0};
        }
        if (this.keys.length == 1) {
            return new Object[]{this.flags, this.sessionTransactionId, this.commandInvocationId, 1, this.keys[0]};
        }
        Object[] retval = new Object[this.keys.length + 4];
        retval[0] = this.flags;
        retval[1] = this.sessionTransactionId;
        retval[2] = this.commandInvocationId;
        retval[3] = this.keys.length;
        System.arraycopy(this.keys, 0, retval, 4, this.keys.length);
        return retval;
    }

    public void setParameters(int commandId, Object[] args) {
        if (commandId != 122) {
            throw new IllegalStateException("Invalid method id");
        }
        this.flags = (Set)args[0];
        this.sessionTransactionId = args[1];
        this.commandInvocationId = (CommandInvocationId)args[2];
        int size = (Integer)args[3];
        this.keys = new Object[size];
        if (size == 1) {
            this.keys[0] = args[4];
        } else if (size > 0) {
            System.arraycopy(args, 4, this.keys, 0, size);
        }
    }

    public byte getCommandId() {
        return 122;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o instanceof BeginInvalidationCommand) {
            BeginInvalidationCommand bic = (BeginInvalidationCommand)((Object)o);
            return EqualsHelper.equals((Object)this.sessionTransactionId, (Object)bic.sessionTransactionId);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + (this.sessionTransactionId == null ? 0 : this.sessionTransactionId.hashCode());
    }

    public String toString() {
        return "BeginInvalidateCommand{keys=" + Arrays.toString(this.keys) + ", sessionTransactionId=" + this.sessionTransactionId + '}';
    }
}

