/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.UUID;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.infinispan.util.InvocationAfterCompletion;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.AdvancedCache;

public class FutureUpdateSynchronization
extends InvocationAfterCompletion {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(FutureUpdateSynchronization.class);
    private final UUID uuid = UUID.randomUUID();
    private final Object key;
    private final Object value;

    public FutureUpdateSynchronization(TransactionCoordinator tc, AdvancedCache cache, boolean requiresTransaction, Object key, Object value) {
        super(tc, cache, requiresTransaction);
        this.key = key;
        this.value = value;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    protected void invoke(boolean success, AdvancedCache cache) {
        while (true) {
            try {
                cache.put(this.key, (Object)new FutureUpdate(this.uuid, success ? this.value : null));
                return;
            }
            catch (Exception e) {
                log.failureInAfterCompletion(e);
                continue;
            }
            break;
        }
    }
}

