/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.AccessDelegate;
import org.hibernate.cache.infinispan.access.FutureUpdateSynchronization;
import org.hibernate.cache.infinispan.access.TombstoneSynchronization;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.Caches;
import org.hibernate.cache.infinispan.util.FutureUpdate;
import org.hibernate.cache.infinispan.util.InfinispanMessageLogger;
import org.hibernate.cache.infinispan.util.Tombstone;
import org.hibernate.cache.infinispan.util.TombstoneUpdate;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.resource.transaction.spi.TransactionCoordinator;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.context.Flag;

public class TombstoneAccessDelegate
implements AccessDelegate {
    private static final InfinispanMessageLogger log = InfinispanMessageLogger.Provider.getLog(TombstoneAccessDelegate.class);
    protected final BaseTransactionalDataRegion region;
    protected final AdvancedCache cache;
    protected final AdvancedCache writeCache;
    protected final AdvancedCache asyncWriteCache;
    protected final AdvancedCache putFromLoadCache;
    protected final boolean requiresTransaction;

    public TombstoneAccessDelegate(BaseTransactionalDataRegion region) {
        this.region = region;
        this.cache = region.getCache();
        this.writeCache = Caches.ignoreReturnValuesCache(this.cache);
        this.asyncWriteCache = Caches.asyncWriteCache(this.cache, Flag.IGNORE_RETURN_VALUES);
        this.putFromLoadCache = this.writeCache.withFlags(new Flag[]{Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.FAIL_SILENTLY});
        Configuration configuration = this.cache.getCacheConfiguration();
        if (configuration.clustering().cacheMode().isInvalidation()) {
            throw new IllegalArgumentException("For tombstone-based caching, invalidation cache is not allowed.");
        }
        if (configuration.transaction().transactionMode().isTransactional()) {
            throw new IllegalArgumentException("Currently transactional caches are not supported.");
        }
        this.requiresTransaction = configuration.transaction().transactionMode().isTransactional() && !configuration.transaction().autoCommit();
    }

    @Override
    public Object get(SharedSessionContractImplementor session, Object key, long txTimestamp) throws CacheException {
        if (txTimestamp < this.region.getLastRegionInvalidation()) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value instanceof Tombstone) {
            return null;
        }
        if (value instanceof FutureUpdate) {
            return ((FutureUpdate)value).getValue();
        }
        return value;
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version) {
        return this.putFromLoad(session, key, value, txTimestamp, version, false);
    }

    @Override
    public boolean putFromLoad(SharedSessionContractImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) throws CacheException {
        long lastRegionInvalidation = this.region.getLastRegionInvalidation();
        if (txTimestamp < lastRegionInvalidation) {
            log.tracef("putFromLoad not executed since tx started at %d, before last region invalidation finished = %d", txTimestamp, lastRegionInvalidation);
            return false;
        }
        if (minimalPutOverride) {
            Object prev = this.cache.get(key);
            if (prev instanceof Tombstone) {
                Tombstone tombstone = (Tombstone)prev;
                long lastTimestamp = tombstone.getLastTimestamp();
                if (txTimestamp <= lastTimestamp) {
                    log.tracef("putFromLoad not executed since tx started at %d, before last invalidation finished = %d", txTimestamp, lastTimestamp);
                    return false;
                }
            } else if (prev != null) {
                log.tracef("putFromLoad not executed since cache contains %s", prev);
                return false;
            }
        }
        this.putFromLoadCache.put(key, new TombstoneUpdate<Object>(session.getTimestamp(), value));
        return true;
    }

    @Override
    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        this.write(session, key, value);
        return true;
    }

    @Override
    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.write(session, key, value);
        return true;
    }

    protected void write(SharedSessionContractImplementor session, Object key, Object value) {
        TransactionCoordinator tc = session.getTransactionCoordinator();
        FutureUpdateSynchronization sync = new FutureUpdateSynchronization(tc, this.writeCache, this.requiresTransaction, key, value);
        this.writeCache.put(key, (Object)new FutureUpdate(sync.getUuid(), null), this.region.getTombstoneExpiration(), TimeUnit.MILLISECONDS);
        tc.getLocalSynchronizations().registerSynchronization((Synchronization)sync);
    }

    @Override
    public void remove(SharedSessionContractImplementor session, Object key) throws CacheException {
        TransactionCoordinator transactionCoordinator = session.getTransactionCoordinator();
        TombstoneSynchronization<Object> sync = new TombstoneSynchronization<Object>(transactionCoordinator, this.asyncWriteCache, this.requiresTransaction, this.region, key);
        Tombstone tombstone = new Tombstone(sync.getUuid(), session.getTimestamp() + this.region.getTombstoneExpiration(), false);
        this.writeCache.put(key, (Object)tombstone, this.region.getTombstoneExpiration(), TimeUnit.MILLISECONDS);
        transactionCoordinator.getLocalSynchronizations().registerSynchronization(sync);
    }

    @Override
    public void removeAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.writeCache.put(key, (Object)TombstoneUpdate.EVICT);
    }

    @Override
    public void evictAll() throws CacheException {
        this.region.beginInvalidation();
        try {
            Caches.broadcastEvictAll(this.cache);
        }
        finally {
            this.region.endInvalidation();
        }
    }

    @Override
    public void unlockItem(SharedSessionContractImplementor session, Object key) throws CacheException {
    }

    @Override
    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) {
        return false;
    }

    @Override
    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        return false;
    }
}

