/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.infinispan.impl.BaseTransactionalDataRegion;
import org.hibernate.cache.infinispan.util.VersionedEntry;
import org.infinispan.AdvancedCache;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.NullValueConverter;
import org.infinispan.interceptors.CallInterceptor;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;

public class VersionedCallInterceptor
extends CallInterceptor {
    private final Comparator<Object> versionComparator;
    private final Metadata expiringMetadata;
    private AdvancedCache cache;
    private Metadata defaultMetadata;

    public VersionedCallInterceptor(BaseTransactionalDataRegion region, Comparator<Object> versionComparator) {
        this.versionComparator = versionComparator;
        this.expiringMetadata = new EmbeddedMetadata.Builder().lifespan(region.getTombstoneExpiration(), TimeUnit.MILLISECONDS).build();
    }

    @Inject
    public void injectDependencies(AdvancedCache cache) {
        this.cache = cache;
    }

    @Start
    public void start() {
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.cacheConfiguration.expiration().lifespan()).maxIdle(this.cacheConfiguration.expiration().maxIdle()).build();
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        MVCCEntry e = (MVCCEntry)ctx.lookupEntry(command.getKey());
        if (e == null) {
            return null;
        }
        Object oldValue = e.getValue();
        Object oldVersion = null;
        long oldTimestamp = Long.MIN_VALUE;
        if (oldValue instanceof VersionedEntry) {
            oldVersion = ((VersionedEntry)oldValue).getVersion();
            oldTimestamp = ((VersionedEntry)oldValue).getTimestamp();
            oldValue = ((VersionedEntry)oldValue).getValue();
        } else if (oldValue instanceof org.hibernate.cache.spi.entry.CacheEntry) {
            oldVersion = ((org.hibernate.cache.spi.entry.CacheEntry)oldValue).getVersion();
        }
        Object newValue = command.getValue();
        Object newVersion = null;
        long newTimestamp = Long.MIN_VALUE;
        Object actualNewValue = newValue;
        boolean isRemoval = false;
        if (newValue instanceof VersionedEntry) {
            VersionedEntry ve = (VersionedEntry)newValue;
            newVersion = ve.getVersion();
            newTimestamp = ve.getTimestamp();
            if (ve.getValue() == null) {
                isRemoval = true;
            } else if (ve.getValue() instanceof org.hibernate.cache.spi.entry.CacheEntry) {
                actualNewValue = ve.getValue();
            }
        } else if (newValue instanceof org.hibernate.cache.spi.entry.CacheEntry) {
            newVersion = ((org.hibernate.cache.spi.entry.CacheEntry)newValue).getVersion();
        }
        if (newVersion == null) {
            this.setValue(e, newValue, this.expiringMetadata);
            return null;
        }
        if (oldVersion == null) {
            assert (oldValue == null || oldTimestamp != Long.MIN_VALUE);
            if (newTimestamp == Long.MIN_VALUE) {
                this.setValue(e, newValue, this.expiringMetadata);
            } else if (newTimestamp <= oldTimestamp) {
                assert (oldValue == null);
            } else {
                this.setValue(e, newValue, this.defaultMetadata);
            }
            return null;
        }
        int compareResult = this.versionComparator.compare(newVersion, oldVersion);
        if (isRemoval && compareResult >= 0) {
            this.setValue(e, newValue, this.expiringMetadata);
        } else if (compareResult > 0) {
            this.setValue(e, actualNewValue, this.defaultMetadata);
        }
        return null;
    }

    private Object setValue(MVCCEntry e, Object value, Metadata metadata) {
        if (e.isRemoved()) {
            e.setRemoved(false);
            e.setCreated(true);
            e.setValid(true);
        } else {
            e.setChanged(true);
        }
        e.setMetadata(metadata);
        return e.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object visitSizeCommand(InvocationContext ctx, SizeCommand command) throws Throwable {
        Set flags = command.getFlags();
        int size = 0;
        AdvancedCache decoratedCache = this.cache.getAdvancedCache().withFlags(flags != null ? flags.toArray(new Flag[flags.size()]) : null);
        try (CloseableIterable iterable = decoratedCache.filterEntries((KeyValueFilter)VersionedEntry.EXCLUDE_EMPTY_EXTRACT_VALUE).converter((Converter)NullValueConverter.getInstance());){
            for (CacheEntry entry : iterable) {
                if (size++ != Integer.MAX_VALUE) continue;
                Integer n = Integer.MAX_VALUE;
                return n;
            }
        }
        return size;
    }
}

