/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.hibernate.cache.AbstractJndiBoundCacheProvider;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.TreeCache;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.transaction.TransactionManagerLookupFactory;

public class JndiBoundTreeCacheProvider
extends AbstractJndiBoundCacheProvider {
    private TransactionManager transactionManager;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new TreeCache(this.getTreeCacheInstance(), regionName, this.transactionManager);
    }

    public void prepare(Properties properties) throws CacheException {
        TransactionManagerLookup transactionManagerLookup = TransactionManagerLookupFactory.getTransactionManagerLookup((Properties)properties);
        if (transactionManagerLookup != null) {
            this.transactionManager = transactionManagerLookup.getTransactionManager(properties);
        }
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public org.jboss.cache.TreeCache getTreeCacheInstance() {
        return (org.jboss.cache.TreeCache)super.getCache();
    }
}

