/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jcache.access;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.jcache.JCacheEntityRegion;
import org.hibernate.cache.jcache.access.AbstractReadWriteRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;

public class ReadWriteEntityRegionAccessStrategy
extends AbstractReadWriteRegionAccessStrategy<JCacheEntityRegion>
implements EntityRegionAccessStrategy {
    public ReadWriteEntityRegionAccessStrategy(JCacheEntityRegion region) {
        super(region);
    }

    public boolean insert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return false;
    }

    public boolean afterInsert(SharedSessionContractImplementor session, Object key, Object value, Object version) throws CacheException {
        return ((JCacheEntityRegion)this.region).putIfAbsent(key, new AbstractReadWriteRegionAccessStrategy.Item(value, version, ((JCacheEntityRegion)this.region).nextTimestamp(), this.nextItemId()));
    }

    public boolean update(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        return false;
    }

    public boolean afterUpdate(SharedSessionContractImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        AbstractReadWriteRegionAccessStrategy.Lockable item;
        while ((item = (AbstractReadWriteRegionAccessStrategy.Lockable)((JCacheEntityRegion)this.region).get(key)) != null && item.isUnlockable(lock)) {
            AbstractReadWriteRegionAccessStrategy.Lock lockItem = (AbstractReadWriteRegionAccessStrategy.Lock)item;
            if (lockItem.wasLockedConcurrently()) {
                if (!((JCacheEntityRegion)this.region).replace(key, lockItem, lockItem.unlock(((JCacheEntityRegion)this.region).nextTimestamp()))) continue;
                return false;
            }
            if (!((JCacheEntityRegion)this.region).replace(key, lockItem, new AbstractReadWriteRegionAccessStrategy.Item(value, currentVersion, ((JCacheEntityRegion)this.region).nextTimestamp(), this.nextItemId()))) continue;
            return true;
        }
        this.handleMissingLock(key, item);
        return false;
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.staticCreateEntityKey((Object)id, (EntityPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.staticGetEntityId((Object)cacheKey);
    }
}

