/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaAttribute;
import org.hibernate.jpamodelgen.MetaEntity;

public class ClassWriter {
    public static void writeFile(MetaEntity entity, Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            StringBuffer body = ClassWriter.generateBody(entity, context);
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(metaModelPackage + "." + entity.getSimpleName() + "_", new Element[0]);
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            pw.println("package " + metaModelPackage + ";");
            pw.println();
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Processing Environment Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ioEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer generateBody(MetaEntity entity, Context context) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            pw.println("@" + entity.importType("javax.persistence.metamodel.StaticMetamodel") + "(" + entity.getSimpleName() + ".class)");
            ClassWriter.printClassDeclaration(entity, pw, context);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                pw.println("\t" + metaMember.getDeclarationString());
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void printClassDeclaration(MetaEntity entity, PrintWriter pw, Context context) {
        pw.print("public abstract class " + entity.getSimpleName() + "_");
        TypeMirror superClass = entity.getTypeElement().getSuperclass();
        String superclassDeclaration = "";
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
            if (context.getMetaEntitiesToProcess().containsKey(superClassName) || context.getMetaSuperclassAndEmbeddableToProcess().containsKey(superClassName)) {
                pw.print(" extends " + superClassName + "_");
            }
        }
        pw.println(" {");
    }
}

