/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.MetaEntity;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.xml.XmlMetaEntity;
import org.hibernate.jpamodelgen.xml.jaxb.AccessType;
import org.hibernate.jpamodelgen.xml.jaxb.Embeddable;
import org.hibernate.jpamodelgen.xml.jaxb.Entity;
import org.hibernate.jpamodelgen.xml.jaxb.EntityMappings;
import org.hibernate.jpamodelgen.xml.jaxb.MappedSuperclass;
import org.hibernate.jpamodelgen.xml.jaxb.ObjectFactory;
import org.hibernate.jpamodelgen.xml.jaxb.Persistence;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitDefaults;
import org.hibernate.jpamodelgen.xml.jaxb.PersistenceUnitMetadata;
import org.xml.sax.SAXException;

@SupportedAnnotationTypes(value={"*"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class JPAMetaModelEntityProcessor
extends AbstractProcessor {
    private static final String PATH_SEPARATOR = "/";
    private static final String PERSISTENCE_XML = "/META-INF/persistence.xml";
    private static final String ORM_XML = "/META-INF/orm.xml";
    private static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private static final String ENTITY_ANN = javax.persistence.Entity.class.getName();
    private static final String MAPPED_SUPERCLASS_ANN = javax.persistence.MappedSuperclass.class.getName();
    private static final String EMBEDDABLE_ANN = javax.persistence.Embeddable.class.getName();
    private static final javax.persistence.AccessType DEFAULT_XML_ACCESS_TYPE = javax.persistence.AccessType.PROPERTY;
    private static final String PERSISTENCE_XML_XSD = "persistence_2_0.xsd";
    private static final String ORM_XSD = "orm_2_0.xsd";
    private boolean xmlProcessed = false;
    private Context context;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.context = new Context(env);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Init Processor " + this);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Last processing round.");
            this.createMetaModelClasses();
            this.context.logMessage(Diagnostic.Kind.NOTE, "Finished processing");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (!this.xmlProcessed) {
            this.parsePersistenceXml();
        }
        if (!this.hostJPAAnnotations(annotations)) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Current processing round does not contain entities");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        Set<? extends Element> elements = roundEnvironment.getRootElements();
        for (Element element : elements) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Processing " + element.toString());
            this.handleRootElementAnnotationMirrors(element);
        }
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void createMetaModelClasses() {
        for (MetaEntity entity : this.context.getMetaEntitiesToProcess().values()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Writing meta model for " + entity);
            ClassWriter.writeFile(entity, this.context);
        }
        for (String className : this.context.getElementsAlreadyProcessed()) {
            this.context.getMetaSuperclassAndEmbeddableToProcess().remove(className);
        }
        for (MetaEntity entity : this.context.getMetaSuperclassAndEmbeddableToProcess().values()) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Writing meta model for " + entity);
            ClassWriter.writeFile(entity, this.context);
        }
    }

    private boolean hostJPAAnnotations(Set<? extends TypeElement> annotations) {
        for (TypeElement typeElement : annotations) {
            String typeName = typeElement.getQualifiedName().toString();
            if (typeName.equals(ENTITY_ANN)) {
                return true;
            }
            if (typeName.equals(EMBEDDABLE_ANN)) {
                return true;
            }
            if (!typeName.equals(MAPPED_SUPERCLASS_ANN)) continue;
            return true;
        }
        return false;
    }

    private void parsePersistenceXml() {
        Persistence persistence = this.parseXml(PERSISTENCE_XML, Persistence.class, PERSISTENCE_XML_XSD);
        if (persistence != null) {
            List<Persistence.PersistenceUnit> persistenceUnits = persistence.getPersistenceUnit();
            for (Persistence.PersistenceUnit unit : persistenceUnits) {
                List<String> mappingFiles = unit.getMappingFile();
                for (String mappingFile : mappingFiles) {
                    this.parsingOrmXml(mappingFile);
                }
            }
        }
        this.parsingOrmXml(ORM_XML);
        this.xmlProcessed = true;
    }

    private void parsingOrmXml(String resource) {
        EntityMappings mappings = this.parseXml(resource, EntityMappings.class, ORM_XSD);
        if (mappings == null) {
            return;
        }
        javax.persistence.AccessType accessType = this.determineGlobalAccessType(mappings);
        this.parseEntities(mappings, accessType);
        this.parseEmbeddable(mappings, accessType);
        this.parseMappedSuperClass(mappings, accessType);
    }

    private javax.persistence.AccessType determineGlobalAccessType(EntityMappings mappings) {
        AccessType xmlAccessType;
        PersistenceUnitDefaults persistenceUnitDefaults;
        javax.persistence.AccessType accessType = DEFAULT_XML_ACCESS_TYPE;
        if (mappings.getAccess() != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(mappings.getAccess());
            return accessType;
        }
        PersistenceUnitMetadata meta = mappings.getPersistenceUnitMetadata();
        if (meta != null && (persistenceUnitDefaults = meta.getPersistenceUnitDefaults()) != null && (xmlAccessType = persistenceUnitDefaults.getAccess()) != null) {
            accessType = this.mapXmlAccessTypeToJpaAccessType(xmlAccessType);
        }
        return accessType;
    }

    private javax.persistence.AccessType mapXmlAccessTypeToJpaAccessType(AccessType xmlAccessType) {
        switch (xmlAccessType) {
            case FIELD: {
                return javax.persistence.AccessType.FIELD;
            }
            case PROPERTY: {
                return javax.persistence.AccessType.PROPERTY;
            }
        }
        return null;
    }

    private void parseEntities(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<Entity> entities = mappings.getEntity();
        for (Entity entity : entities) {
            String fullyQualifiedClassName = packageName + "." + entity.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(entity, packageName, this.getXmlMappedType(fullyQualifiedClassName));
            if (this.context.getMetaEntitiesToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaEntitiesToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private boolean xmlMappedTypeExists(String fullyQualifiedClassName) {
        Elements utils = this.processingEnv.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName) != null;
    }

    private TypeElement getXmlMappedType(String fullyQualifiedClassName) {
        Elements utils = this.processingEnv.getElementUtils();
        return utils.getTypeElement(fullyQualifiedClassName);
    }

    private void parseEmbeddable(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<Embeddable> embeddables = mappings.getEmbeddable();
        for (Embeddable embeddable : embeddables) {
            String fullyQualifiedClassName = packageName + "." + embeddable.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(embeddable, packageName, this.getXmlMappedType(fullyQualifiedClassName));
            if (this.context.getMetaSuperclassAndEmbeddableToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private void parseMappedSuperClass(EntityMappings mappings, javax.persistence.AccessType accessType) {
        String packageName = mappings.getPackage();
        List<MappedSuperclass> mappedSuperClasses = mappings.getMappedSuperclass();
        for (MappedSuperclass mappedSuperClass : mappedSuperClasses) {
            String fullyQualifiedClassName = packageName + "." + mappedSuperClass.getClazz();
            if (!this.xmlMappedTypeExists(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " is mapped in xml, but class does not exists. Skipping meta model generation.");
                continue;
            }
            XmlMetaEntity metaEntity = new XmlMetaEntity(mappedSuperClass, packageName, this.getXmlMappedType(fullyQualifiedClassName));
            if (this.context.getMetaSuperclassAndEmbeddableToProcess().containsKey(fullyQualifiedClassName)) {
                this.context.logMessage(Diagnostic.Kind.WARNING, fullyQualifiedClassName + " was already processed once. Skipping second occurance.");
            }
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(fullyQualifiedClassName, metaEntity);
        }
    }

    private void handleRootElementAnnotationMirrors(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            AnnotationMetaEntity metaEntity;
            String annotationType = annotationMirror.getAnnotationType().toString();
            if (element.getKind() != ElementKind.CLASS) continue;
            if (annotationType.equals(ENTITY_ANN)) {
                metaEntity = new AnnotationMetaEntity((TypeElement)element, this.context);
                this.context.getMetaEntitiesToProcess().put(metaEntity.getQualifiedName(), metaEntity);
                continue;
            }
            if (!annotationType.equals(MAPPED_SUPERCLASS_ANN) && !annotationType.equals(EMBEDDABLE_ANN)) continue;
            metaEntity = new AnnotationMetaEntity((TypeElement)element, this.context);
            this.context.getMetaSuperclassAndEmbeddableToProcess().put(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    private InputStream getInputStreamForResource(String resource) {
        InputStream ormStream;
        String pkg = this.getPackage(resource);
        String name = this.getRelativeName(resource);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Reading resource " + resource);
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, pkg, name);
            ormStream = fileObject.openInputStream();
        }
        catch (IOException e1) {
            ormStream = this.getClass().getResourceAsStream(resource);
        }
        return ormStream;
    }

    private <T> T parseXml(String resource, Class<T> clazz, String schemaName) {
        InputStream stream = this.getInputStreamForResource(resource);
        if (stream == null) {
            this.context.logMessage(Diagnostic.Kind.NOTE, resource + " not found.");
            return null;
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            if (schemaName != null) {
                unmarshaller.setSchema(this.getSchema(schemaName));
            }
            return clazz.cast(unmarshaller.unmarshal(stream));
        }
        catch (JAXBException e) {
            String message = "Error unmarshalling " + resource + " with exception :\n " + (Object)((Object)e);
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
        catch (Exception e) {
            String message = "Error reading " + resource + " with exception :\n " + e;
            this.context.logMessage(Diagnostic.Kind.WARNING, message);
            return null;
        }
    }

    private String getPackage(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return "";
        }
        return resourceName.substring(0, resourceName.lastIndexOf(PATH_SEPARATOR));
    }

    private String getRelativeName(String resourceName) {
        if (!resourceName.contains(PATH_SEPARATOR)) {
            return resourceName;
        }
        return resourceName.substring(resourceName.lastIndexOf(PATH_SEPARATOR) + 1);
    }

    private Schema getSchema(String schemaName) {
        Schema schema = null;
        URL schemaUrl = this.getClass().getClassLoader().getResource(schemaName);
        if (schemaUrl == null) {
            return schema;
        }
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            schema = sf.newSchema(schemaUrl);
        }
        catch (SAXException e) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to create schema for " + schemaName + ": " + e.getMessage());
        }
        return schema;
    }
}

