/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TypeUtils {
    private static final Map<String, String> PRIMITIVES = new HashMap<String, String>();

    public static String toTypeString(TypeMirror type) {
        if (type.getKind().isPrimitive()) {
            return PRIMITIVES.get(((Object)type).toString());
        }
        return ((Object)type).toString();
    }

    public static TypeElement getSuperclass(TypeElement element) {
        TypeMirror superClass = element.getSuperclass();
        String superclassDeclaration = "";
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            return (TypeElement)superClassElement;
        }
        return null;
    }

    static {
        PRIMITIVES.put("char", "Character");
        PRIMITIVES.put("byte", "Byte");
        PRIMITIVES.put("short", "Short");
        PRIMITIVES.put("int", "Integer");
        PRIMITIVES.put("long", "Long");
        PRIMITIVES.put("boolean", "Boolean");
        PRIMITIVES.put("float", "Float");
        PRIMITIVES.put("double", "Double");
    }
}

