/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.ImportContext;
import org.hibernate.jpamodelgen.ImportContextImpl;
import org.hibernate.jpamodelgen.MetaAttribute;
import org.hibernate.jpamodelgen.MetaEntity;
import org.hibernate.jpamodelgen.TypeUtils;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaCollection;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaMap;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaSingleAttribute;

public class AnnotationMetaEntity
implements MetaEntity {
    static Map<String, String> COLLECTIONS = new HashMap<String, String>();
    private final TypeElement element;
    private final ImportContext importContext;
    private Context context;
    private AccessType defaultAccessTypeForHierarchy;
    private AccessType defaultAccessTypeForElement;

    public AnnotationMetaEntity(TypeElement element, Context context) {
        this.element = element;
        this.context = context;
        this.importContext = new ImportContextImpl(this.getPackageName());
    }

    public AnnotationMetaEntity(TypeElement element, Context context, AccessType accessType) {
        this(element, context);
        this.defaultAccessTypeForHierarchy = accessType;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    @Override
    public String getQualifiedName() {
        return this.element.getQualifiedName().toString();
    }

    @Override
    public String getPackageName() {
        PackageElement packageOf = this.context.getProcessingEnvironment().getElementUtils().getPackageOf(this.element);
        return this.context.getProcessingEnvironment().getElementUtils().getName(packageOf.getQualifiedName()).toString();
    }

    @Override
    public List<MetaAttribute> getMembers() {
        ArrayList<MetaAttribute> membersFound = new ArrayList<MetaAttribute>();
        AccessType elementAccessType = this.getAccessTypeForElement();
        List<VariableElement> fieldsOfClass = ElementFilter.fieldsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(membersFound, elementAccessType, fieldsOfClass, AccessType.FIELD);
        List<ExecutableElement> methodsOfClass = ElementFilter.methodsIn(this.element.getEnclosedElements());
        this.addPersistentMembers(membersFound, elementAccessType, methodsOfClass, AccessType.PROPERTY);
        TypeElement superclass = TypeUtils.getSuperclass(this.element);
        while (superclass != null && superclass.getAnnotation(Entity.class) == null) {
            if (superclass.getAnnotation(MappedSuperclass.class) != null) {
                this.context.processElement(superclass, this.defaultAccessTypeForHierarchy);
            }
            superclass = TypeUtils.getSuperclass(superclass);
        }
        return membersFound;
    }

    private void addPersistentMembers(List<MetaAttribute> membersFound, AccessType elementAccessType, List<? extends Element> membersOfClass, AccessType membersKind) {
        AccessType explicitAccessType = elementAccessType == membersKind ? null : membersKind;
        for (Element element : membersOfClass) {
            TypeVisitor visitor = new TypeVisitor(this, explicitAccessType);
            AnnotationMetaAttribute result = element.asType().accept(visitor, element);
            if (result == null) continue;
            membersFound.add(result);
        }
    }

    private AccessType getAccessTypeForElement() {
        AccessType accessType = this.getAccessTypeForClass(this.element);
        if (accessType == null) {
            accessType = this.defaultAccessTypeForHierarchy;
        }
        if (accessType == null) {
            AccessType superClassAccessType;
            TypeElement superClass = this.element;
            while (!((superClass = TypeUtils.getSuperclass(superClass)) != null && (superClass.getAnnotation(Entity.class) == null && superClass.getAnnotation(MappedSuperclass.class) == null || (superClassAccessType = this.getAccessTypeForClass(superClass)) != null && this.defaultAccessTypeForHierarchy != null) || superClass == null)) {
            }
        }
        if (accessType == null) {
            this.defaultAccessTypeForElement = accessType = AccessType.PROPERTY;
        }
        this.context.addAccessType(this.element, accessType);
        this.defaultAccessTypeForElement = accessType;
        return accessType;
    }

    private AccessType getAccessTypeForClass(TypeElement searchedElement) {
        AccessType forcedAccessType;
        this.context.logMessage(Diagnostic.Kind.NOTE, "check class " + searchedElement);
        AccessType accessType = this.context.getAccessType(searchedElement);
        if (this.defaultAccessTypeForHierarchy == null) {
            this.defaultAccessTypeForHierarchy = this.context.getDefaultAccessTypeForHerarchy(searchedElement);
        }
        if (accessType != null) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "Found in cache" + searchedElement + ":" + accessType);
            return accessType;
        }
        Access accessAnn = searchedElement.getAnnotation(Access.class);
        AccessType accessType2 = forcedAccessType = accessAnn != null ? accessAnn.value() : null;
        if (forcedAccessType != null) {
            this.context.logMessage(Diagnostic.Kind.NOTE, "access type " + searchedElement + ":" + forcedAccessType);
            this.context.addAccessType(searchedElement, forcedAccessType);
        }
        if (forcedAccessType == null || this.defaultAccessTypeForHierarchy == null) {
            List<? extends Element> myMembers = searchedElement.getEnclosedElements();
            for (Element element : myMembers) {
                List<? extends AnnotationMirror> entityAnnotations = this.context.getProcessingEnvironment().getElementUtils().getAllAnnotationMirrors(element);
                for (AnnotationMirror annotationMirror : entityAnnotations) {
                    AnnotationMirror annotationMirror2 = annotationMirror;
                    String annotationType = annotationMirror2.getAnnotationType().toString();
                    if (!annotationType.equals(Id.class.getName()) && !annotationType.equals(EmbeddedId.class.getName())) continue;
                    this.context.logMessage(Diagnostic.Kind.NOTE, "Found id on" + searchedElement);
                    ElementKind kind = element.getKind();
                    if (kind != ElementKind.FIELD && kind != ElementKind.METHOD) continue;
                    AccessType accessType3 = accessType = kind == ElementKind.FIELD ? AccessType.FIELD : AccessType.PROPERTY;
                    if (this.defaultAccessTypeForHierarchy == null) {
                        this.defaultAccessTypeForHierarchy = this.context.getDefaultAccessTypeForHerarchy(searchedElement);
                        if (this.defaultAccessTypeForHierarchy == null) {
                            this.defaultAccessTypeForHierarchy = accessType;
                            this.context.addAccessTypeForHierarchy(searchedElement, this.defaultAccessTypeForHierarchy);
                        }
                    }
                    if (forcedAccessType == null) {
                        this.context.addAccessType(searchedElement, accessType);
                        this.context.logMessage(Diagnostic.Kind.NOTE, "access type " + searchedElement + ":" + accessType);
                        return accessType;
                    }
                    return forcedAccessType;
                }
            }
        }
        return forcedAccessType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetaEntity");
        sb.append("{element=").append(this.element);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public String generateImports() {
        return this.importContext.generateImports();
    }

    @Override
    public String importType(String fqcn) {
        return this.importContext.importType(fqcn);
    }

    @Override
    public String staticImport(String fqcn, String member) {
        return this.importContext.staticImport(fqcn, member);
    }

    @Override
    public String importType(Name qualifiedName) {
        return this.importType(qualifiedName.toString());
    }

    @Override
    public TypeElement getTypeElement() {
        return this.element;
    }

    private String getKeyType(DeclaredType t) {
        return ((Object)t.getTypeArguments().get(0)).toString();
    }

    private String getElementType(DeclaredType declaredType) {
        if (declaredType.getTypeArguments().size() == 1) {
            return ((Object)declaredType.getTypeArguments().get(0)).toString();
        }
        return ((Object)declaredType.getTypeArguments().get(1)).toString();
    }

    static {
        COLLECTIONS.put("java.util.Collection", "javax.persistence.metamodel.CollectionAttribute");
        COLLECTIONS.put("java.util.Set", "javax.persistence.metamodel.SetAttribute");
        COLLECTIONS.put("java.util.List", "javax.persistence.metamodel.ListAttribute");
        COLLECTIONS.put("java.util.Map", "javax.persistence.metamodel.MapAttribute");
    }

    class TypeVisitor
    extends SimpleTypeVisitor6<AnnotationMetaAttribute, Element> {
        AnnotationMetaEntity parent;
        private AccessType explicitAccessType;

        TypeVisitor(AnnotationMetaEntity parent, AccessType explicitAccessType) {
            this.parent = parent;
            this.explicitAccessType = explicitAccessType;
        }

        @Override
        protected AnnotationMetaAttribute defaultAction(TypeMirror e, Element p) {
            return (AnnotationMetaAttribute)super.defaultAction(e, p);
        }

        @Override
        public AnnotationMetaAttribute visitPrimitive(PrimitiveType t, Element element) {
            if (this.isPersistent(element)) {
                return new AnnotationMetaSingleAttribute(this.parent, element, TypeUtils.toTypeString(t));
            }
            return null;
        }

        @Override
        public AnnotationMetaAttribute visitArray(ArrayType t, Element element) {
            if (this.isPersistent(element)) {
                return new AnnotationMetaSingleAttribute(this.parent, element, TypeUtils.toTypeString(t));
            }
            return null;
        }

        private boolean isPersistent(Element element) {
            boolean correctAccessType = false;
            if (this.explicitAccessType == null) {
                correctAccessType = true;
            } else {
                Access accessAnn = element.getAnnotation(Access.class);
                if (accessAnn != null && this.explicitAccessType.equals((Object)accessAnn.value())) {
                    correctAccessType = true;
                }
            }
            return correctAccessType && element.getAnnotation(Transient.class) == null && !element.getModifiers().contains((Object)Modifier.TRANSIENT) && !element.getModifiers().contains((Object)Modifier.STATIC);
        }

        @Override
        public AnnotationMetaAttribute visitDeclared(DeclaredType t, Element element) {
            if (this.isPersistent(element)) {
                TypeElement returnedElement = (TypeElement)AnnotationMetaEntity.this.context.getProcessingEnvironment().getTypeUtils().asElement(t);
                String fqElementName = returnedElement.getQualifiedName().toString();
                String collection = COLLECTIONS.get(fqElementName);
                if (collection != null) {
                    if (element.getAnnotation(ElementCollection.class) != null) {
                        TypeMirror collectionElementType = this.getCollectionElementType(t, fqElementName);
                        TypeElement collectionElement = (TypeElement)AnnotationMetaEntity.this.context.getProcessingEnvironment().getTypeUtils().asElement(collectionElementType);
                        this.parent.context.processElement(collectionElement, this.parent.defaultAccessTypeForElement);
                    }
                    if (collection.equals("javax.persistence.metamodel.MapAttribute")) {
                        return new AnnotationMetaMap(this.parent, element, collection, AnnotationMetaEntity.this.getKeyType(t), AnnotationMetaEntity.this.getElementType(t));
                    }
                    return new AnnotationMetaCollection(this.parent, element, collection, AnnotationMetaEntity.this.getElementType(t));
                }
                if (element.getAnnotation(Embedded.class) != null || returnedElement.getAnnotation(Embeddable.class) != null) {
                    this.parent.context.processElement(returnedElement, this.parent.defaultAccessTypeForElement);
                }
                return new AnnotationMetaSingleAttribute(this.parent, element, returnedElement.getQualifiedName().toString());
            }
            return null;
        }

        private TypeMirror getCollectionElementType(DeclaredType t, String fqElementName) {
            TypeMirror collectionElementType = Map.class.getCanonicalName().equals(fqElementName) ? t.getTypeArguments().get(1) : t.getTypeArguments().get(0);
            return collectionElementType;
        }

        @Override
        public AnnotationMetaAttribute visitExecutable(ExecutableType t, Element p) {
            String string = p.getSimpleName().toString();
            if (string.startsWith("get") || string.startsWith("is")) {
                TypeMirror returnType = t.getReturnType();
                return returnType.accept(this, p);
            }
            return null;
        }
    }
}

