/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.model.MetaAttribute;
import org.hibernate.jpamodelgen.model.MetaEntity;

public final class ClassWriter {
    private static final String META_MODEL_CLASS_NAME_SUFFIX = "_";

    private ClassWriter() {
    }

    public static void writeFile(MetaEntity entity, Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            StringBuffer body = ClassWriter.generateBody(entity, context);
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(ClassWriter.getFullyQualifiedClassName(entity, metaModelPackage), new Element[0]);
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            if (!metaModelPackage.isEmpty()) {
                pw.println("package " + metaModelPackage + ";");
                pw.println();
            }
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ioEx.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuffer generateBody(MetaEntity entity, Context context) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(sw);
            if (context.isAddGeneratedAnnotation()) {
                pw.println(ClassWriter.writeGeneratedAnnotation(entity));
            }
            pw.println(ClassWriter.writeStaticMetaModelAnnotation(entity));
            ClassWriter.printClassDeclaration(entity, pw, context);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                pw.println("\t" + metaMember.getDeclarationString());
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
    }

    private static void printClassDeclaration(MetaEntity entity, PrintWriter pw, Context context) {
        pw.print("public abstract class " + entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX);
        TypeMirror superClass = entity.getTypeElement().getSuperclass();
        if (superClass.getKind() == TypeKind.DECLARED) {
            Element superClassElement = ((DeclaredType)superClass).asElement();
            String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
            if (ClassWriter.extendsSuperMetaModel(superClassElement, entity.isMetaComplete(), context)) {
                pw.print(" extends " + superClassName + META_MODEL_CLASS_NAME_SUFFIX);
            }
        }
        pw.println(" {");
    }

    private static boolean extendsSuperMetaModel(Element superClassElement, boolean entityMetaComplete, Context context) {
        String superClassName = ((TypeElement)superClassElement).getQualifiedName().toString();
        if (context.containsMetaEntity(superClassName) || context.containsMetaEmbeddable(superClassName)) {
            return true;
        }
        return !entityMetaComplete && (superClassElement.getAnnotation(Entity.class) != null || superClassElement.getAnnotation(MappedSuperclass.class) != null);
    }

    private static String getFullyQualifiedClassName(MetaEntity entity, String metaModelPackage) {
        String fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = fullyQualifiedClassName + entity.getSimpleName() + META_MODEL_CLASS_NAME_SUFFIX;
        return fullyQualifiedClassName;
    }

    private static String writeGeneratedAnnotation(MetaEntity entity) {
        return "@" + entity.importType(Generated.class.getName()) + "(\"JPA MetaModel for " + entity.getQualifiedName() + "\")";
    }

    private static String writeStaticMetaModelAnnotation(MetaEntity entity) {
        return "@" + entity.importType("javax.persistence.metamodel.StaticMetamodel") + "(" + entity.getSimpleName() + ".class)";
    }
}

