/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public final class Constants {
    public static final String ENTITY = "javax.persistence.Entity";
    public static final String MAPPED_SUPERCLASS = "javax.persistence.MappedSuperclass";
    public static final String EMBEDDABLE = "javax.persistence.Embeddable";
    public static final String ID = "javax.persistence.Id";
    public static final String EMBEDDED_ID = "javax.persistence.EmbeddedId";
    public static final String TRANSIENT = "javax.persistence.Transient";
    public static final String BASIC = "javax.persistence.Basic";
    public static final String ONE_TO_ONE = "javax.persistence.OneToOne";
    public static final String ONE_TO_MANY = "javax.persistence.OneToMany";
    public static final String MANY_TO_ONE = "javax.persistence.ManyToOne";
    public static final String MANY_TO_MANY = "javax.persistence.ManyToMany";
    public static final String MAP_KEY_CLASS = "javax.persistence.MapKeyClass";
    public static final String ELEMENT_COLLECTION = "javax.persistence.ElementCollection";
    public static final String ACCESS = "javax.persistence.Access";
    public static final String MAP_ATTRIBUTE = "javax.persistence.metamodel.MapAttribute";
    public static final String CONVERT = "javax.persistence.Convert";
    public static final String HIBERNATE_TYPE = "org.hibernate.annotations.Type";
    public static final Map<String, String> COLLECTIONS = Constants.allCollectionTypes();
    public static final List<String> BASIC_TYPES = Constants.allBasicTypes();
    public static final List<String> BASIC_ARRAY_TYPES = Constants.allBasicArrayTypes();
    public static final String PATH_SEPARATOR = "/";

    private static Map<String, String> allCollectionTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(Collection.class.getName(), "javax.persistence.metamodel.CollectionAttribute");
        map.put(Set.class.getName(), "javax.persistence.metamodel.SetAttribute");
        map.put(List.class.getName(), "javax.persistence.metamodel.ListAttribute");
        map.put(Map.class.getName(), MAP_ATTRIBUTE);
        map.put(SortedSet.class.getName(), "javax.persistence.metamodel.SetAttribute");
        map.put(SortedMap.class.getName(), MAP_ATTRIBUTE);
        return Collections.unmodifiableMap(map);
    }

    private static List<String> allBasicTypes() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(String.class.getName());
        strings.add(Boolean.class.getName());
        strings.add(Byte.class.getName());
        strings.add(Character.class.getName());
        strings.add(Short.class.getName());
        strings.add(Integer.class.getName());
        strings.add(Long.class.getName());
        strings.add(Float.class.getName());
        strings.add(Double.class.getName());
        strings.add(BigInteger.class.getName());
        strings.add(BigDecimal.class.getName());
        strings.add(java.util.Date.class.getName());
        strings.add(Calendar.class.getName());
        strings.add(Date.class.getName());
        strings.add(Time.class.getName());
        strings.add(Timestamp.class.getName());
        strings.add(Blob.class.getName());
        return Collections.unmodifiableList(strings);
    }

    private static List<String> allBasicArrayTypes() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(Character.class.getName());
        strings.add(Byte.class.getName());
        return Collections.unmodifiableList(strings);
    }

    private Constants() {
    }
}

