/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Collection;
import org.hibernate.SessionFactory;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.osgi.OSGiClassLoaderServiceImpl;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiServiceUtil;
import org.hibernate.service.ServiceRegistry;
import org.jboss.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiSessionFactoryService
implements ServiceFactory {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)OsgiSessionFactoryService.class.getName());
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private OsgiServiceUtil osgiServiceUtil;

    public OsgiSessionFactoryService(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, OsgiServiceUtil osgiServiceUtil) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.osgiServiceUtil = osgiServiceUtil;
    }

    public Object getService(Bundle requestingBundle, ServiceRegistration registration) {
        TypeContributor[] typeContributors;
        StrategyRegistrationProvider[] strategyRegistrationProviders;
        Integrator[] integrators;
        this.osgiClassLoader.addBundle(requestingBundle);
        BootstrapServiceRegistryBuilder bsrBuilder = new BootstrapServiceRegistryBuilder();
        bsrBuilder.applyClassLoaderService((ClassLoaderService)new OSGiClassLoaderServiceImpl(this.osgiClassLoader, this.osgiServiceUtil));
        for (Integrator integrator : integrators = this.osgiServiceUtil.getServiceImpls(Integrator.class)) {
            bsrBuilder.applyIntegrator(integrator);
        }
        for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviders = this.osgiServiceUtil.getServiceImpls(StrategyRegistrationProvider.class)) {
            bsrBuilder.withStrategySelectors(strategyRegistrationProvider);
        }
        BootstrapServiceRegistry bsr = bsrBuilder.build();
        StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
        BundleWiring bundleWiring = (BundleWiring)requestingBundle.adapt(BundleWiring.class);
        Collection cfgResources = bundleWiring.listResources("/", "hibernate.cfg.xml", 1);
        if (cfgResources.size() == 0) {
            ssrBuilder.configure();
        } else {
            if (cfgResources.size() > 1) {
                LOG.warn((Object)"Multiple hibernate.cfg.xml files found in the persistence bundle.  Using the first one discovered.");
            }
            String cfgResource = "/" + (String)cfgResources.iterator().next();
            ssrBuilder.configure(cfgResource);
        }
        ssrBuilder.applySetting("hibernate.transaction.jta.platform", (Object)this.osgiJtaPlatform);
        StandardServiceRegistry ssr = ssrBuilder.build();
        MetadataBuilder metadataBuilder = new MetadataSources((ServiceRegistry)ssr).getMetadataBuilder();
        for (TypeContributor typeContributor : typeContributors = this.osgiServiceUtil.getServiceImpls(TypeContributor.class)) {
            metadataBuilder.applyTypes(typeContributor);
        }
        return metadataBuilder.build().buildSessionFactory();
    }

    public void ungetService(Bundle requestingBundle, ServiceRegistration registration, Object service) {
        ((SessionFactory)service).close();
    }
}

