/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.persistence.PersistenceException;
import org.hibernate.boot.archive.spi.ArchiveContext;
import org.hibernate.boot.archive.spi.ArchiveDescriptor;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class OsgiArchiveDescriptor
implements ArchiveDescriptor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(OsgiArchiveDescriptor.class);
    private final Bundle persistenceBundle;
    private final BundleWiring bundleWiring;

    public OsgiArchiveDescriptor(Bundle persistenceBundle) {
        this.persistenceBundle = persistenceBundle;
        this.bundleWiring = (BundleWiring)persistenceBundle.adapt(BundleWiring.class);
    }

    public void visitArchive(ArchiveContext context) {
        Collection resources = this.bundleWiring.listResources("/", "*", 1);
        for (final String resource : resources) {
            if (resource.endsWith("/")) continue;
            try {
                final InputStreamAccess inputStreamAccess = new InputStreamAccess(){

                    public String getStreamName() {
                        return resource;
                    }

                    public InputStream accessInputStream() {
                        return this.openInputStream();
                    }

                    private InputStream openInputStream() {
                        try {
                            return OsgiArchiveDescriptor.this.persistenceBundle.getResource(resource).openStream();
                        }
                        catch (IOException e) {
                            throw new PersistenceException("Unable to open an InputStream on the OSGi Bundle resource!", (Throwable)e);
                        }
                    }
                };
                ArchiveEntry entry = new ArchiveEntry(){

                    public String getName() {
                        return resource;
                    }

                    public String getNameWithinArchive() {
                        return resource;
                    }

                    public InputStreamAccess getStreamAccess() {
                        return inputStreamAccess;
                    }
                };
                context.obtainArchiveEntryHandler(entry).handleEntry(entry, context);
            }
            catch (Exception e) {
                LOG.unableToLoadScannedClassOrResource(e);
            }
        }
    }
}

