/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.boot.model.TypeContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.hibernate.jpa.boot.spi.Bootstrap;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.osgi.OSGiClassLoaderServiceImpl;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiScanner;
import org.hibernate.osgi.OsgiServiceUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class OsgiPersistenceProvider
extends HibernatePersistenceProvider {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private OsgiServiceUtil osgiServiceUtil;
    private Bundle requestingBundle;

    public OsgiPersistenceProvider(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, OsgiServiceUtil osgiServiceUtil, Bundle requestingBundle) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.osgiServiceUtil = osgiServiceUtil;
        this.requestingBundle = requestingBundle;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        Map settings = this.generateSettings(properties);
        settings.put("hibernate.archive.scanner", new OsgiScanner(this.requestingBundle));
        settings.put("hibernate.classLoader.environment", this.osgiClassLoader);
        this.osgiClassLoader.addBundle(this.requestingBundle);
        EntityManagerFactoryBuilder builder = this.getEntityManagerFactoryBuilderOrNull(persistenceUnitName, settings, new OSGiClassLoaderServiceImpl(this.osgiClassLoader, this.osgiServiceUtil));
        return builder == null ? null : builder.build();
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        Map settings = this.generateSettings(properties);
        settings.put("hibernate.archive.scanner", new OsgiScanner(((BundleReference)info.getClassLoader()).getBundle()));
        this.osgiClassLoader.addClassLoader(info.getClassLoader());
        return Bootstrap.getEntityManagerFactoryBuilder((PersistenceUnitInfo)info, (Map)settings, (ClassLoaderService)new OSGiClassLoaderServiceImpl(this.osgiClassLoader, this.osgiServiceUtil)).build();
    }

    private Map generateSettings(Map properties) {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        if (properties != null) {
            settings.putAll(properties);
        }
        settings.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        final Integrator[] integrators = this.osgiServiceUtil.getServiceImpls(Integrator.class);
        IntegratorProvider integratorProvider = new IntegratorProvider(){

            public List<Integrator> getIntegrators() {
                return Arrays.asList(integrators);
            }
        };
        settings.put("hibernate.integrator_provider", integratorProvider);
        final StrategyRegistrationProvider[] strategyRegistrationProviders = this.osgiServiceUtil.getServiceImpls(StrategyRegistrationProvider.class);
        StrategyRegistrationProviderList strategyRegistrationProviderList = new StrategyRegistrationProviderList(){

            public List<StrategyRegistrationProvider> getStrategyRegistrationProviders() {
                return Arrays.asList(strategyRegistrationProviders);
            }
        };
        settings.put("hibernate.strategy_registration_provider", strategyRegistrationProviderList);
        final TypeContributor[] typeContributors = this.osgiServiceUtil.getServiceImpls(TypeContributor.class);
        TypeContributorList typeContributorList = new TypeContributorList(){

            public List<TypeContributor> getTypeContributors() {
                return Arrays.asList(typeContributors);
            }
        };
        settings.put("hibernate.type_contributors", typeContributorList);
        return settings;
    }
}

