/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.client.impl;

import io.searchbox.action.Action;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.HttpClientConfig;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.search.backend.elasticsearch.impl.GsonBuilderHolder;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;

public class JestClient
implements Service,
Startable,
Stoppable {
    private io.searchbox.client.JestClient client;

    public void start(Properties properties, BuildContext context) {
        JestClientFactory factory = new JestClientFactory();
        String serverUri = ConfigurationParseHelper.getString((Properties)properties, (String)"hibernate.search.elasticsearch.host", (String)"http://localhost:9200");
        factory.setHttpClientConfig(((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)((HttpClientConfig.Builder)new HttpClientConfig.Builder(serverUri).multiThreaded(true)).readTimeout(2000)).connTimeout(2000)).gson(GsonBuilderHolder.BUILDER)).build());
        this.client = factory.getObject();
    }

    public void stop() {
        this.client.shutdownClient();
    }

    public <T extends JestResult> T executeRequest(Action<T> request) {
        return this.executeRequest(request, true);
    }

    public <T extends JestResult> T executeRequest(Action<T> request, boolean failOnError) {
        try {
            JestResult result = this.client.execute(request);
            if (failOnError && !result.isSucceeded()) {
                throw new SearchException(result.getErrorMessage());
            }
            return (T)result;
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }
}

