/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.backend.elasticsearch.impl.ElasticsearchIndexWorkVisitor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;

public class ElasticsearchBackendQueueProcessor
implements BackendQueueProcessor {
    private ElasticsearchIndexManager indexManager;

    public void initialize(Properties props, WorkerBuildContext context, IndexManager indexManager) {
        this.indexManager = (ElasticsearchIndexManager)indexManager;
    }

    public void close() {
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        for (LuceneWork luceneWork : workList) {
            luceneWork.acceptIndexWorkVisitor((IndexWorkVisitor)new ElasticsearchIndexWorkVisitor(this.indexManager.getActualIndexName(), this.indexManager.searchIntegrator), null);
        }
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        singleOperation.acceptIndexWorkVisitor((IndexWorkVisitor)new ElasticsearchIndexWorkVisitor(this.indexManager.getActualIndexName(), this.indexManager.searchIntegrator), null);
    }

    public Lock getExclusiveWriteLock() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void indexMappingChanged() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void closeIndexWriter() {
    }
}

