/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.PutMapping;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.BackendFactory;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.elasticsearch.cfg.IndexManagementStrategy;
import org.hibernate.search.backend.elasticsearch.client.impl.JestClient;
import org.hibernate.search.backend.elasticsearch.impl.ConfigurationPropertiesProvider;
import org.hibernate.search.backend.elasticsearch.impl.FieldHelper;
import org.hibernate.search.backend.elasticsearch.impl.IndexNameNormalizer;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.serialization.impl.LuceneWorkSerializerImpl;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.serialization.spi.SerializationProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchIndexManager
implements IndexManager {
    private static final Log LOG = LoggerFactory.make();
    private String indexName;
    private String actualIndexName;
    private IndexManagementStrategy indexManagementStrategy;
    private Similarity similarity;
    ExtendedSearchIntegrator searchIntegrator;
    private final Set<Class<?>> containedEntityTypes = new HashSet();
    private ServiceReference<JestClient> clientReference;
    private BackendQueueProcessor backend;
    private LuceneWorkSerializer serializer;
    private SerializationProvider serializationProvider;
    private ServiceManager serviceManager;

    public void initialize(String indexName, Properties properties, Similarity similarity, WorkerBuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.indexName = this.getIndexName(indexName, properties);
        try (ServiceReference propertiesProvider = this.serviceManager.requestReference(ConfigurationPropertiesProvider.class);){
            this.indexManagementStrategy = this.getIndexManagementStrategy(((ConfigurationPropertiesProvider)propertiesProvider.get()).getProperties());
        }
        this.actualIndexName = IndexNameNormalizer.getElasticsearchIndexName(this.indexName);
        this.similarity = similarity;
        this.backend = BackendFactory.createBackend((IndexManager)this, (WorkerBuildContext)context, (Properties)properties);
    }

    private String getIndexName(String indexName, Properties properties) {
        String name = properties.getProperty("indexName");
        return name != null ? name : indexName;
    }

    private IndexManagementStrategy getIndexManagementStrategy(Properties properties) {
        String strategy = properties.getProperty("hibernate.search.elasticsearch.index_management_strategy");
        return strategy != null ? IndexManagementStrategy.valueOf(strategy) : IndexManagementStrategy.NONE;
    }

    public void destroy() {
        if (this.indexManagementStrategy == IndexManagementStrategy.CREATE_DELETE) {
            this.deleteIndexIfExisting();
        }
        this.clientReference.close();
    }

    public void setSearchFactory(ExtendedSearchIntegrator boundSearchIntegrator) {
        this.searchIntegrator = boundSearchIntegrator;
        this.clientReference = this.searchIntegrator.getServiceManager().requestReference(JestClient.class);
        this.initializeIndex();
    }

    private void initializeIndex() {
        if (this.indexManagementStrategy == IndexManagementStrategy.NONE) {
            return;
        }
        if (this.indexManagementStrategy == IndexManagementStrategy.CREATE || this.indexManagementStrategy == IndexManagementStrategy.CREATE_DELETE) {
            this.deleteIndexIfExisting();
            this.createIndex();
            this.createIndexMappings();
        } else if (this.indexManagementStrategy == IndexManagementStrategy.MERGE) {
            this.createIndexIfNotYetExisting();
            this.createIndexMappings();
        }
    }

    public void addContainedEntity(Class<?> entity) {
        this.containedEntityTypes.add(entity);
    }

    private void createIndex() {
        ((JestClient)this.clientReference.get()).executeRequest(new CreateIndex.Builder(this.actualIndexName).build());
    }

    private void createIndexIfNotYetExisting() {
        if (((JestClient)this.clientReference.get()).executeRequest(new IndicesExists.Builder(this.actualIndexName).build(), false).getResponseCode() == 200) {
            return;
        }
        ((JestClient)this.clientReference.get()).executeRequest(new CreateIndex.Builder(this.actualIndexName).build());
    }

    private void deleteIndexIfExisting() {
        block3: {
            if (((JestClient)this.clientReference.get()).executeRequest(new IndicesExists.Builder(this.actualIndexName).build(), false).getResponseCode() == 404) {
                return;
            }
            try {
                ((JestClient)this.clientReference.get()).executeRequest(new DeleteIndex.Builder(this.actualIndexName).build());
            }
            catch (SearchException e) {
                if (e.getMessage().contains("index_not_found_exception")) break block3;
                throw e;
            }
        }
    }

    private void createIndexMappings() {
        for (Class<?> entityType : this.containedEntityTypes) {
            EntityIndexBinding descriptor = this.searchIntegrator.getIndexBinding(entityType);
            JsonObject payload = new JsonObject();
            payload.addProperty("dynamic", "strict");
            JsonObject properties = new JsonObject();
            payload.add("properties", (JsonElement)properties);
            JsonObject field = new JsonObject();
            field.addProperty("type", "string");
            properties.add("__HSearch_TenantId", (JsonElement)field);
            for (DocumentFieldMetadata fieldMetadata : descriptor.getDocumentBuilder().getTypeMetadata().getAllDocumentFieldMetadata()) {
                if (fieldMetadata.isId() || fieldMetadata.getFieldName().isEmpty() || fieldMetadata.getFieldName().endsWith(".")) continue;
                this.addFieldMapping(payload, descriptor, fieldMetadata);
            }
            for (BridgeDefinedField bridgeDefinedField : this.getAllBridgeDefinedFields(descriptor)) {
                this.addFieldMapping(payload, bridgeDefinedField);
            }
            PutMapping putMapping = new PutMapping.Builder(this.actualIndexName, entityType.getName(), (Object)payload).build();
            try {
                ((JestClient)this.clientReference.get()).executeRequest(putMapping);
            }
            catch (Exception e) {
                throw new SearchException("Could not create mapping for entity type " + entityType.getName(), (Throwable)e);
            }
        }
    }

    private void addFieldMapping(JsonObject payload, EntityIndexBinding descriptor, DocumentFieldMetadata fieldMetadata) {
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(fieldMetadata.getName());
        JsonObject field = new JsonObject();
        String fieldType = this.getFieldType(descriptor, fieldMetadata);
        if (fieldType == null) {
            LOG.debug((Object)("Not adding a mapping for field " + fieldMetadata.getFieldName() + " as its type could not be determined"));
            return;
        }
        field.addProperty("type", fieldType);
        field.addProperty("store", Boolean.valueOf(fieldMetadata.getStore() != Store.NO));
        field.addProperty("index", this.getIndex(descriptor, fieldMetadata));
        if (fieldMetadata.getBoost() != null) {
            field.addProperty("boost", (Number)fieldMetadata.getBoost());
        }
        if (fieldMetadata.indexNullAs() != null) {
            field.addProperty("null_value", fieldMetadata.indexNullAs());
        }
        this.getOrCreateProperties(payload, fieldMetadata.getName()).add(simpleFieldName, (JsonElement)field);
        for (FacetMetadata facetMetadata : fieldMetadata.getFacetMetadata()) {
            if (facetMetadata.getFacetName().equals(fieldMetadata.getFieldName())) continue;
            this.addFieldMapping(payload, facetMetadata);
        }
    }

    private JsonObject addFieldMapping(JsonObject payload, BridgeDefinedField bridgeDefinedField) {
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(bridgeDefinedField.getName());
        JsonObject field = new JsonObject();
        field.addProperty("type", this.getFieldType(bridgeDefinedField));
        field.addProperty("index", "analyzed");
        this.getOrCreateProperties(payload, bridgeDefinedField.getName()).add(simpleFieldName, (JsonElement)field);
        return field;
    }

    private JsonObject addFieldMapping(JsonObject payload, FacetMetadata facetMetadata) {
        String simpleFieldName = FieldHelper.getEmbeddedFieldPropertyName(facetMetadata.getFacetName());
        String fullFieldName = facetMetadata.getFacetName();
        JsonObject field = new JsonObject();
        field.addProperty("type", this.getFieldType(facetMetadata));
        field.addProperty("store", Boolean.valueOf(false));
        field.addProperty("index", "not_analyzed");
        this.getOrCreateProperties(payload, fullFieldName).add(simpleFieldName, (JsonElement)field);
        return field;
    }

    private String getIndex(EntityIndexBinding binding, DocumentFieldMetadata fieldMetadata) {
        if (FieldHelper.isBoolean(binding, fieldMetadata.getName())) {
            return "not_analyzed";
        }
        switch (fieldMetadata.getIndex()) {
            case ANALYZED: 
            case ANALYZED_NO_NORMS: {
                return "analyzed";
            }
            case NOT_ANALYZED: 
            case NOT_ANALYZED_NO_NORMS: {
                return "not_analyzed";
            }
            case NO: {
                return "no";
            }
        }
        throw new IllegalArgumentException("Unexpected index type: " + fieldMetadata.getIndex());
    }

    private String getFieldType(EntityIndexBinding descriptor, DocumentFieldMetadata fieldMetadata) {
        String type;
        if (FieldHelper.isBoolean(descriptor, fieldMetadata.getName())) {
            type = "boolean";
        } else if (FieldHelper.isDate(descriptor, fieldMetadata.getName())) {
            type = "date";
        } else if (FieldHelper.isNumeric(fieldMetadata)) {
            NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = FieldHelper.getNumericEncodingType(descriptor, fieldMetadata);
            switch (numericEncodingType) {
                case INTEGER: {
                    type = "integer";
                    break;
                }
                case LONG: {
                    type = "long";
                    break;
                }
                case FLOAT: {
                    type = "float";
                    break;
                }
                case DOUBLE: {
                    type = "double";
                    break;
                }
                default: {
                    type = null;
                    break;
                }
            }
        } else {
            type = "string";
        }
        return type;
    }

    private String getFieldType(BridgeDefinedField bridgeDefinedField) {
        switch (bridgeDefinedField.getType()) {
            case BOOLEAN: {
                return "boolean";
            }
            case DATE: {
                return "date";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case INTEGER: {
                return "integer";
            }
            case LONG: {
                return "long";
            }
            case STRING: {
                return "string";
            }
        }
        throw new SearchException("Unexpected field type: " + bridgeDefinedField.getType());
    }

    private String getFieldType(FacetMetadata facetMetadata) {
        switch (facetMetadata.getEncoding()) {
            case DOUBLE: {
                return "double";
            }
            case LONG: {
                return "long";
            }
            case STRING: {
                return "string";
            }
            case AUTO: {
                throw new AssertionFailure("The facet type should have been resolved during bootstrapping");
            }
        }
        throw new AssertionFailure("Unexpected facet encoding type '" + facetMetadata.getEncoding() + "' Has the enum been modified?");
    }

    private JsonObject getOrCreateProperties(JsonObject mapping, String fieldName) {
        if (!FieldHelper.isEmbeddedField(fieldName)) {
            return mapping.getAsJsonObject("properties");
        }
        JsonObject parentProperties = mapping.getAsJsonObject("properties");
        String[] parts = fieldName.split("\\.");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            JsonObject property = parentProperties.getAsJsonObject(part);
            if (property == null) {
                property = new JsonObject();
                JsonObject properties = new JsonObject();
                property.add("properties", (JsonElement)properties);
                parentProperties.add(part, (JsonElement)property);
                parentProperties = properties;
                continue;
            }
            parentProperties = property.getAsJsonObject("properties");
        }
        return parentProperties;
    }

    private Set<BridgeDefinedField> getAllBridgeDefinedFields(EntityIndexBinding binding) {
        HashSet<BridgeDefinedField> bridgeDefinedFields = new HashSet<BridgeDefinedField>();
        this.collectPropertyLevelBridgeDefinedFields(binding.getDocumentBuilder().getMetadata(), bridgeDefinedFields);
        return bridgeDefinedFields;
    }

    private void collectPropertyLevelBridgeDefinedFields(TypeMetadata type, Set<BridgeDefinedField> allBridgeDefinedFields) {
        allBridgeDefinedFields.addAll(type.getClassBridgeDefinedFields());
        if (type.getIdPropertyMetadata() != null) {
            allBridgeDefinedFields.addAll(type.getIdPropertyMetadata().getBridgeDefinedFields().values());
        }
        for (PropertyMetadata property : type.getAllPropertyMetadata()) {
            allBridgeDefinedFields.addAll(property.getBridgeDefinedFields().values());
        }
        for (TypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            this.collectPropertyLevelBridgeDefinedFields(embeddedType, allBridgeDefinedFields);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    public ReaderProvider getReaderProvider() {
        throw new UnsupportedOperationException("No ReaderProvider / IndexReader with ES");
    }

    public Set<Class<?>> getContainedTypes() {
        return this.containedEntityTypes;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchIntegrator.getAnalyzer(name);
    }

    public LuceneWorkSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializationProvider = this.requestSerializationProvider();
            this.serializer = new LuceneWorkSerializerImpl(this.serializationProvider, this.searchIntegrator);
            LOG.indexManagerUsesSerializationService(this.indexName, this.serializer.describeSerializer());
        }
        return this.serializer;
    }

    public void closeIndexWriter() {
    }

    private SerializationProvider requestSerializationProvider() {
        try {
            return (SerializationProvider)this.serviceManager.requestService(SerializationProvider.class);
        }
        catch (SearchException se) {
            throw LOG.serializationProviderNotFoundException((Exception)((Object)se));
        }
    }

    public String getActualIndexName() {
        return this.actualIndexName;
    }

    public void performOperations(List<LuceneWork> queue, IndexingMonitor monitor) {
        this.backend.applyWork(queue, monitor);
    }

    public void performStreamOperation(LuceneWork singleOperation, IndexingMonitor monitor, boolean forceAsync) {
        this.backend.applyStreamWork(singleOperation, monitor);
    }

    public void optimize() {
    }

    public String toString() {
        return "ElasticsearchIndexManager [actualIndexName=" + this.actualIndexName + "]";
    }
}

