/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.core.Delete;
import io.searchbox.core.DeleteByQuery;
import io.searchbox.core.Index;
import io.searchbox.indices.Refresh;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.IndexWorkVisitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.elasticsearch.client.impl.JestClient;
import org.hibernate.search.backend.elasticsearch.impl.DocumentIdHelper;
import org.hibernate.search.backend.elasticsearch.impl.FieldHelper;
import org.hibernate.search.backend.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.backend.spi.DeleteByQueryLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ElasticsearchIndexWorkVisitor
implements IndexWorkVisitor<Void, Void> {
    private static final Log LOG = LoggerFactory.make();
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern NAME_AND_INDEX = Pattern.compile("(.+?)(\\[([0-9])+\\])?");
    private static final String DELETE_ALL_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"match_all\" : { } } } } }";
    private static final String DELETE_ALL_FOR_TENANT_QUERY = "{ \"query\" : { \"constant_score\" : { \"filter\" : { \"term\" : { \"__HSearch_TenantId\" : \"%s\" } } } } }";
    private final String indexName;
    private final ExtendedSearchIntegrator searchIntegrator;

    public ElasticsearchIndexWorkVisitor(String indexName, ExtendedSearchIntegrator searchIntegrator) {
        this.indexName = indexName;
        this.searchIntegrator = searchIntegrator;
    }

    public Void visitAddWork(AddLuceneWork work, Void p) {
        this.indexDocument(DocumentIdHelper.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass());
        return null;
    }

    public Void visitDeleteWork(DeleteLuceneWork work, Void p) {
        Delete delete = ((Delete.Builder)((Delete.Builder)((Delete.Builder)new Delete.Builder(DocumentIdHelper.getDocumentId((LuceneWork)work)).index(this.indexName)).type(work.getEntityClass().getName())).setParameter("refresh", (Object)true)).build();
        try (ServiceReference client = this.searchIntegrator.getServiceManager().requestReference(JestClient.class);){
            ((JestClient)client.get()).executeRequest(delete, false);
        }
        return null;
    }

    public Void visitOptimizeWork(OptimizeLuceneWork work, Void p) {
        LOG.warn((Object)"Optimize work is not yet supported for Elasticsearch backend, ignoring it");
        return null;
    }

    public Void visitPurgeAllWork(PurgeAllLuceneWork work, Void p) {
        String query = work.getTenantId() != null ? String.format(Locale.ENGLISH, DELETE_ALL_FOR_TENANT_QUERY, work.getTenantId()) : DELETE_ALL_QUERY;
        DeleteByQuery.Builder builder = (DeleteByQuery.Builder)new DeleteByQuery.Builder(query).addIndex(this.indexName);
        Set typesToDelete = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{work.getEntityClass()});
        for (Class typeToDelete : typesToDelete) {
            builder.addType(typeToDelete.getName());
        }
        DeleteByQuery delete = builder.build();
        Refresh refresh = ((Refresh.Builder)new Refresh.Builder().addIndex(this.indexName)).build();
        try (ServiceReference client = this.searchIntegrator.getServiceManager().requestReference(JestClient.class);){
            ((JestClient)client.get()).executeRequest(delete);
            ((JestClient)client.get()).executeRequest(refresh);
        }
        return null;
    }

    public Void visitUpdateWork(UpdateLuceneWork work, Void p) {
        this.indexDocument(DocumentIdHelper.getDocumentId((LuceneWork)work), work.getDocument(), work.getEntityClass());
        return null;
    }

    public Void visitFlushWork(FlushLuceneWork work, Void p) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public Void visitDeleteByQueryWork(DeleteByQueryLuceneWork work, Void p) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private void indexDocument(String id, Document document, Class<?> entityType) {
        JsonObject source = this.convertToJson(document, entityType);
        String type = entityType.getName();
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)source).index(this.indexName)).type(type)).id(id)).setParameter("refresh", (Object)true)).build();
        try (ServiceReference client = this.searchIntegrator.getServiceManager().requestReference(JestClient.class);){
            ((JestClient)client.get()).executeRequest(index);
        }
    }

    private JsonObject convertToJson(Document document, Class<?> entityType) {
        EntityIndexBinding indexBinding = this.searchIntegrator.getIndexBinding(entityType);
        JsonObject source = new JsonObject();
        String parentPath = null;
        for (IndexableField field : document.getFields()) {
            if ("$nesting".equals(field.name())) {
                parentPath = field.stringValue();
                continue;
            }
            if (!(field.name().equals("_hibernate_class") || field.name().equals(indexBinding.getDocumentBuilder().getIdKeywordName()) || "$facets".equals(field.name()) || this.isDocValueField(field))) {
                Object value;
                JsonObject parent = this.getOrCreateDocumentTree(source, parentPath);
                String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(field.name());
                DocumentFieldMetadata documentFieldMetadata = indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name());
                if (documentFieldMetadata == null) {
                    String[] fieldNameParts = FieldHelper.getFieldNameParts(field.name());
                    EmbeddedTypeMetadata embeddedType = this.getEmbeddedTypeMetadata(indexBinding.getDocumentBuilder().getTypeMetadata(), fieldNameParts);
                    if (embeddedType != null) continue;
                    String stringValue = field.stringValue();
                    if (stringValue != null) {
                        this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, new JsonPrimitive(stringValue));
                        continue;
                    }
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, field.numericValue() != null ? new JsonPrimitive(field.numericValue()) : null);
                    continue;
                }
                if (FieldHelper.isBoolean(indexBinding, field.name())) {
                    FieldBridge fieldBridge = documentFieldMetadata.getFieldBridge();
                    Boolean value2 = (Boolean)((TwoWayFieldBridge)fieldBridge).get(field.name(), document);
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value2 != null ? new JsonPrimitive(value2) : null);
                    continue;
                }
                if (FieldHelper.isNumeric(documentFieldMetadata) || this.isNumeric(field)) {
                    value = field.numericValue();
                    if (value != null && value.toString().equals(documentFieldMetadata.indexNullAs())) {
                        value = null;
                    }
                    this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive((Number)value) : null);
                    continue;
                }
                value = field.stringValue();
                if (value != null && ((String)value).equals(documentFieldMetadata.indexNullAs())) {
                    value = null;
                }
                this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive((String)value) : null);
                continue;
            }
            if ("$facets".equals(field.name()) && field instanceof SortedSetDocValuesField) {
                String[] facetParts = FacetsConfig.stringToPath((String)field.binaryValue().utf8ToString());
                if (facetParts == null || facetParts.length != 2) continue;
                String fieldName = facetParts[0];
                String value = facetParts[1];
                if (indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(fieldName) != null) continue;
                JsonObject parent = this.getOrCreateDocumentTree(source, fieldName);
                String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(fieldName);
                this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive(value) : null);
                continue;
            }
            if (!this.isDocValueField(field) || !(field instanceof NumericDocValuesField) || indexBinding.getDocumentBuilder().getTypeMetadata().getDocumentFieldMetadataFor(field.name()) != null) continue;
            Number value = field instanceof DoubleDocValuesField ? (Number)Double.longBitsToDouble(field.numericValue().longValue()) : (Number)field.numericValue();
            JsonObject parent = this.getOrCreateDocumentTree(source, parentPath);
            String jsonPropertyName = FieldHelper.getEmbeddedFieldPropertyName(field.name());
            this.addPropertyOfPotentiallyMultipleCardinality(parent, jsonPropertyName, value != null ? new JsonPrimitive(value) : null);
        }
        return source;
    }

    private void addPropertyOfPotentiallyMultipleCardinality(JsonObject parent, String propertyName, JsonPrimitive value) {
        JsonElement currentValue = parent.get(propertyName);
        if (currentValue == null) {
            JsonBuilder.object(parent).add(propertyName, (JsonElement)value);
        } else if (!currentValue.isJsonArray()) {
            parent.remove(propertyName);
            parent.add(propertyName, (JsonElement)JsonBuilder.array().add(currentValue).add((JsonElement)value).build());
        } else {
            currentValue.getAsJsonArray().add((JsonElement)value);
        }
    }

    private boolean isNumeric(IndexableField field) {
        return field instanceof IntField || field instanceof LongField || field instanceof FloatField || field instanceof DoubleField;
    }

    private EmbeddedTypeMetadata getEmbeddedTypeMetadata(TypeMetadata type, String[] fieldNameParts) {
        TypeMetadata parent = type;
        for (String namePart : fieldNameParts) {
            EmbeddedTypeMetadata embeddedType = this.getDirectEmbeddedTypeMetadata(parent, namePart);
            if (embeddedType == null) {
                return null;
            }
            parent = embeddedType;
        }
        return (EmbeddedTypeMetadata)parent;
    }

    private EmbeddedTypeMetadata getDirectEmbeddedTypeMetadata(TypeMetadata type, String fieldName) {
        for (EmbeddedTypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            if (!embeddedType.getEmbeddedFieldName().equals(fieldName)) continue;
            return embeddedType;
        }
        return null;
    }

    private JsonObject getOrCreateDocumentTree(JsonObject source, String path) {
        if (path == null) {
            return source;
        }
        String[] parts = DOT.split(path);
        JsonObject parent = source;
        for (int i = 0; i < parts.length; ++i) {
            Matcher nameAndIndex = NAME_AND_INDEX.matcher(parts[i]);
            nameAndIndex.matches();
            String name = nameAndIndex.group(1);
            String idx = nameAndIndex.group(3);
            Integer index = null;
            if (idx != null) {
                JsonObject newParent;
                index = Integer.valueOf(idx);
                JsonArray array = parent.getAsJsonArray(name);
                if (array == null) {
                    array = new JsonArray();
                    parent.add(name, (JsonElement)array);
                }
                JsonObject jsonObject = newParent = index < array.size() ? array.get(index.intValue()).getAsJsonObject() : null;
                if (newParent == null) {
                    newParent = new JsonObject();
                    if (index >= array.size()) {
                        for (int j = array.size(); j <= index; ++j) {
                            array.add((JsonElement)JsonNull.INSTANCE);
                        }
                    }
                    array.set(index.intValue(), (JsonElement)newParent);
                }
                parent = newParent;
                continue;
            }
            JsonObject newParent = parent.getAsJsonObject(name);
            if (newParent == null) {
                newParent = new JsonObject();
                parent.add(name, (JsonElement)newParent);
            }
            parent = newParent;
        }
        return parent;
    }

    private boolean isDocValueField(IndexableField field) {
        return field.fieldType().docValuesType() != DocValuesType.NONE;
    }
}

