/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import java.util.Set;
import java.util.regex.Pattern;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;

class FieldHelper {
    private static final Pattern DOT = Pattern.compile("\\.");

    private FieldHelper() {
    }

    static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(EntityIndexBinding indexBinding, DocumentFieldMetadata field) {
        BridgeDefinedField bridgeDefinedField;
        PropertyMetadata hostingProperty;
        NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = field.getNumericEncodingType();
        if (numericEncodingType == NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN && (hostingProperty = FieldHelper.getPropertyMetadata(indexBinding, field.getName())) != null && (bridgeDefinedField = (BridgeDefinedField)hostingProperty.getBridgeDefinedFields().get(field.getName())) != null) {
            numericEncodingType = FieldHelper.getNumericEncodingType(bridgeDefinedField.getType());
        }
        return numericEncodingType;
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncodingType(FieldType fieldType) {
        switch (fieldType) {
            case FLOAT: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.FLOAT;
            }
            case DOUBLE: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.DOUBLE;
            }
            case INTEGER: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
            }
            case LONG: {
                return NumericFieldSettingsDescriptor.NumericEncodingType.LONG;
            }
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }

    static boolean isBoolean(EntityIndexBinding indexBinding, String fieldName) {
        String propertyTypeName = FieldHelper.getPropertyTypeName(indexBinding, fieldName);
        return "boolean".equals(propertyTypeName) || "java.lang.Boolean".equals(propertyTypeName);
    }

    static boolean isDate(EntityIndexBinding indexBinding, String fieldName) {
        String propertyTypeName = FieldHelper.getPropertyTypeName(indexBinding, fieldName);
        return "java.util.Date".equals(propertyTypeName);
    }

    static boolean isNumeric(DocumentFieldMetadata field) {
        if (field.isNumeric()) {
            return true;
        }
        FieldBridge fieldBridge = field.getFieldBridge();
        if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
            return ((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap() instanceof NumericFieldBridge;
        }
        return false;
    }

    static String[] getFieldNameParts(String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        return stringArray;
    }

    private static String getPropertyTypeName(EntityIndexBinding indexBinding, String fieldName) {
        PropertyMetadata propertyMetadata = FieldHelper.getPropertyMetadata(indexBinding, fieldName);
        return propertyMetadata != null ? propertyMetadata.getPropertyAccessor().getType().getName() : null;
    }

    private static PropertyMetadata getPropertyMetadata(EntityIndexBinding indexBinding, String fieldName) {
        String[] stringArray;
        boolean isEmbeddedField = FieldHelper.isEmbeddedField(fieldName);
        if (isEmbeddedField) {
            stringArray = DOT.split(fieldName);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fieldName;
        }
        String[] fieldNameParts = stringArray;
        TypeMetadata typeMetadata = isEmbeddedField ? FieldHelper.getLeafTypeMetadata(indexBinding, fieldNameParts) : indexBinding.getDocumentBuilder().getMetadata();
        PropertyMetadata property = FieldHelper.getPropertyMetadata(typeMetadata, fieldName, fieldNameParts);
        if (property != null) {
            return property;
        }
        return null;
    }

    static DocumentFieldMetadata getFieldMetadata(EntityIndexBinding indexBinding, String fieldName) {
        if (indexBinding.getDocumentBuilder().getIdentifierName().equals(fieldName)) {
            return indexBinding.getDocumentBuilder().getTypeMetadata().getIdPropertyMetadata().getFieldMetadata(fieldName);
        }
        PropertyMetadata property = FieldHelper.getPropertyMetadata(indexBinding, fieldName);
        if (property != null) {
            return property.getFieldMetadata(fieldName);
        }
        Set classBridgeMetadata = indexBinding.getDocumentBuilder().getMetadata().getClassBridgeMetadata();
        for (DocumentFieldMetadata documentFieldMetadata : classBridgeMetadata) {
            if (!documentFieldMetadata.getFieldName().equals(fieldName)) continue;
            return documentFieldMetadata;
        }
        return null;
    }

    private static TypeMetadata getLeafTypeMetadata(EntityIndexBinding indexBinding, String[] fieldNameParts) {
        TypeMetadata parentMetadata = indexBinding.getDocumentBuilder().getMetadata();
        block0: for (int i = 0; i < fieldNameParts.length - 1; ++i) {
            for (EmbeddedTypeMetadata embeddedTypeMetadata : parentMetadata.getEmbeddedTypeMetadata()) {
                if (!embeddedTypeMetadata.getEmbeddedFieldName().equals(fieldNameParts[i])) continue;
                parentMetadata = embeddedTypeMetadata;
                continue block0;
            }
        }
        return parentMetadata;
    }

    private static PropertyMetadata getPropertyMetadata(TypeMetadata type, String fieldName, String[] fieldNameParts) {
        String lastParticle = fieldNameParts[fieldNameParts.length - 1];
        for (PropertyMetadata property : type.getAllPropertyMetadata()) {
            for (DocumentFieldMetadata field : property.getFieldMetadata()) {
                if (!field.getName().equals(fieldName)) continue;
                return property;
            }
        }
        for (EmbeddedTypeMetadata embeddedType : type.getEmbeddedTypeMetadata()) {
            if (!lastParticle.startsWith(embeddedType.getEmbeddedFieldName())) continue;
            for (PropertyMetadata property : embeddedType.getAllPropertyMetadata()) {
                for (DocumentFieldMetadata field : embeddedType.getAllDocumentFieldMetadata()) {
                    if (!field.getName().equals(fieldName)) continue;
                    return property;
                }
            }
        }
        return null;
    }

    public static boolean isEmbeddedField(String field) {
        return field.contains(".");
    }

    public static String getEmbeddedFieldPath(String field) {
        return field.substring(0, field.lastIndexOf("."));
    }

    public static String getEmbeddedFieldPropertyName(String field) {
        return field.substring(field.lastIndexOf(".") + 1);
    }
}

