/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Date;
import org.hibernate.search.backend.elasticsearch.impl.GsonBuilderHolder;

public class JsonBuilder {
    private JsonBuilder() {
    }

    public static Array array() {
        return new Array();
    }

    public static Array array(JsonArray jsonArray) {
        return new Array(jsonArray);
    }

    public static Object object() {
        return new Object();
    }

    public static Object object(JsonObject jsonObject) {
        return new Object(jsonObject);
    }

    public static class Object {
        private JsonObject jsonObject = new JsonObject();

        private Object() {
        }

        private Object(JsonObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        public Object add(String property, JsonElement element) {
            this.jsonObject.add(property, element);
            return this;
        }

        public Object add(String property, Array element) {
            this.jsonObject.add(property, (JsonElement)element.build());
            return this;
        }

        public Object add(String property, Object element) {
            this.jsonObject.add(property, (JsonElement)element.build());
            return this;
        }

        public Object addProperty(String property, java.lang.Object value) {
            if (value instanceof String || value == null) {
                this.jsonObject.addProperty(property, (String)value);
            } else if (value instanceof Number) {
                this.jsonObject.addProperty(property, (Number)value);
            } else if (value instanceof Boolean) {
                this.jsonObject.addProperty(property, (Boolean)value);
            } else if (value instanceof Character) {
                this.jsonObject.addProperty(property, (Character)value);
            } else if (value instanceof Date) {
                this.jsonObject.addProperty(property, GsonBuilderHolder.BUILDER.toJson(value).replace("\"", ""));
            } else {
                this.jsonObject.addProperty(property, value.toString());
            }
            return this;
        }

        public Object addProperty(String property, Boolean value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, Number value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, Character value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public Object addProperty(String property, String value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public JsonObject build() {
            return this.jsonObject;
        }

        public String toString() {
            return this.jsonObject.toString();
        }
    }

    public static class Array {
        private JsonArray jsonArray = new JsonArray();

        private Array() {
        }

        private Array(JsonArray jsonArray) {
            this.jsonArray = jsonArray;
        }

        public Array add(JsonElement element) {
            this.jsonArray.add(element);
            return this;
        }

        public Array add(Array element) {
            this.jsonArray.add((JsonElement)element.build());
            return this;
        }

        public Array add(Object element) {
            this.jsonArray.add((JsonElement)element.build());
            return this;
        }

        public JsonArray build() {
            return this.jsonArray;
        }

        public String toString() {
            return this.jsonArray.toString();
        }

        public int size() {
            return this.jsonArray.size();
        }
    }
}

