/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.nio.charset.Charset;
import org.hibernate.search.SearchException;

public final class MessageSerializationHelper {
    private static final Charset STRING_ENCODING = Charset.forName("UTF-8");

    private MessageSerializationHelper() {
    }

    public static byte[] prependString(String name, byte[] data) {
        byte[] string = name.getBytes(STRING_ENCODING);
        if (string.length > 255) {
            throw new SearchException("Index name is too long to be encoded");
        }
        byte[] result = new byte[data.length + string.length + 1];
        result[0] = MessageSerializationHelper.fromIntToByte(string.length);
        System.arraycopy(string, 0, result, 1, string.length);
        System.arraycopy(data, 0, result, 1 + string.length, data.length);
        return result;
    }

    public static String extractIndexName(byte[] rawBuffer) {
        int indexNameByteLength = MessageSerializationHelper.fromByteToInt(rawBuffer[0]);
        return new String(rawBuffer, 1, indexNameByteLength, STRING_ENCODING);
    }

    public static byte[] extractSerializedQueue(byte[] rawBuffer) {
        byte indexNameByteLength = rawBuffer[0];
        byte[] serializedQueue = new byte[rawBuffer.length - 1 - indexNameByteLength];
        System.arraycopy(rawBuffer, indexNameByteLength + 1, serializedQueue, 0, serializedQueue.length);
        return serializedQueue;
    }

    public static int fromByteToInt(byte b) {
        return b & 0xFF;
    }

    public static byte fromIntToByte(int i) {
        if (i > 255) {
            throw new SearchException("Int is too long to be encoded");
        }
        return (byte)i;
    }
}

