/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.logging.impl;

import java.util.Properties;
import org.hibernate.search.exception.SearchException;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;
import org.jgroups.Address;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends org.hibernate.search.util.logging.impl.Log {
    @Message(id=200001, value="Remote JGroups peer '%1$s' is suspected to have left '")
    public SuspectedException jgroupsSuspectingPeer(Address var1);

    @Message(id=200002, value="Timeout sending synchronous message to JGroups peer '%1$s''")
    public TimeoutException jgroupsRpcTimeout(Address var1);

    @Message(id=200003, value="Exception reported from remote JGroups node '%1$s' : '%2$s'")
    public SearchException jgroupsRemoteException(Address var1, Throwable var2, @Cause Throwable var3);

    @Message(id=200004, value="Unable to send Lucene update work via JGroups cluster")
    public SearchException unableToSendWorkViaJGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200005, value="Received null or empty Lucene works list in message.")
    public void receivedEmptyLuceneWorksInMessage();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200006, value="Received new cluster view: %1$s")
    public void jGroupsReceivedNewClusterView(Object var1);

    @Message(id=200007, value="Configured JGroups channel is a Muxer! MuxId option is required: define '%s'.")
    public SearchException missingJGroupsMuxId(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=200008, value="Starting JGroups ChannelProvider")
    public void jGroupsStartingChannelProvider();

    @Message(id=200009, value="MuxId '%1$d' configured on the JGroups was already taken. Can't register handler!")
    public SearchException jGroupsMuxIdAlreadyTaken(short var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200010, value="FLUSH is not present in your JGroups stack! FLUSH is needed to ensure messages are not dropped while new nodes join the cluster. Will proceed, but inconsistencies may arise!")
    public void jGroupsFlushNotPresentInStack();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=200011, value="Using JGroups channel having configuration '%1$s'")
    public void jgroupsFullConfiguration(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=200012, value="Problem closing channel; setting it to null")
    public void jGroupsClosingChannelError(@Cause Exception var1);

    @Message(id=200013, value="Object injected for JGroups channel in %1$s is of an unexpected type %2$s (expecting org.jgroups.JChannel)")
    public SearchException jGroupsChannelInjectionError(String var1, @Cause Exception var2, Class<?> var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=200014, value="Starting JGroups channel using configuration '%1$s'")
    public void startingJGroupsChannel(Object var1);

    @Message(id=200015, value="Error while trying to create a channel using config file: %1$s")
    public SearchException jGroupsChannelCreationUsingFileError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200016, value="Unable to use any JGroups configuration mechanisms provided in properties %1$s. Using default JGroups configuration file!")
    public void jGroupsConfigurationNotFoundInProperties(Properties var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200017, value="Disconnecting and closing JGroups Channel to cluster '%1$s'")
    public void jGroupsDisconnectingAndClosingChannel(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=200018, value="Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!")
    public void jGroupsDefaultConfigurationFileNotFound();

    @Message(id=200019, value="Unable to start JGroups channel")
    public SearchException unableToStartJGroupsChannel(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=200020, value="Connected to cluster [ %1$s ]. The local Address is %2$s")
    public void jGroupsConnectedToCluster(String var1, Object var2);

    @Message(id=200021, value="Unable to connect to: [%1$s] JGroups channel")
    public SearchException unableConnectingToJGroupsCluster(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=200022, value="JGroups backend configured for index '%1$s' using block_for_ack '%2$s'")
    public void jgroupsBlockWaitingForAck(String var1, boolean var2);

    @Message(id=200023, value="JGroups channel configuration should be specified in the global section [hibernate.search.services.jgroups.], not as an IndexManager property for index '%1$s'. See http://docs.jboss.org/hibernate/search/4.1/reference/en-US/html_single/#jgroups-backend")
    public SearchException legacyJGroupsConfigurationDefined(String var1);
}

