/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.View;

public final class AutoNodeSelector
implements NodeSelectorStrategy {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private volatile Address localAddress;
    private volatile Address masterAddress;

    public AutoNodeSelector(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public boolean isIndexOwnerLocal() {
        return this.localAddress == null || this.localAddress.equals(this.masterAddress);
    }

    @Override
    public void setLocalAddress(Address address) {
        this.localAddress = address;
    }

    @Override
    public void viewAccepted(View view) {
        List members = view.getMembers();
        if (members.size() == 1) {
            this.masterAddress = (Address)members.get(0);
        } else if (members.size() == 2) {
            this.masterAddress = (Address)members.get(1);
        } else {
            int selectionRange = members.size() - 1;
            int selected = Math.abs(this.indexName.hashCode() % selectionRange) + 1;
            this.masterAddress = (Address)members.get(selected);
        }
        log.acceptingNewClusterView(view, this.masterAddress, this.indexName);
    }
}

