/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.net.URL;
import java.util.Properties;
import org.hibernate.search.backend.jgroups.impl.ClassloaderMessageListener;
import org.hibernate.search.backend.jgroups.impl.JGroupsMasterMessageListener;
import org.hibernate.search.backend.jgroups.impl.MessageListenerToRequestHandlerAdapter;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.mux.MuxMessageDispatcher;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public final class DispatchMessageSender
implements MessageSenderService,
Startable,
Stoppable {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    public static final String JGROUPS_PREFIX = "hibernate.search.services.jgroups.";
    public static final String CONFIGURATION_FILE = "hibernate.search.services.jgroups.configurationFile";
    public static final String CLUSTER_NAME = "hibernate.search.services.jgroups.clusterName";
    public static final String CHANNEL_INJECT = "hibernate.search.services.jgroups.providedChannel";
    public static final String CLASSLOADER = "hibernate.search.services.jgroups.classloader";
    public static final String MUX_ID = "hibernate.search.services.jgroups.mux_id";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    private static final String DEFAULT_CLUSTER_NAME = "Hibernate Search Cluster";
    private ChannelContainer channelContainer;
    private ServiceManager serviceManager;
    private MessageDispatcher dispatcher;

    @Override
    public Address getAddress() {
        return this.channelContainer.getChannel().getAddress();
    }

    @Override
    public View getView() {
        return this.channelContainer.getChannel().getView();
    }

    @Override
    public void send(Message message, boolean synchronous, long timeout) throws Exception {
        RequestOptions options = synchronous ? RequestOptions.SYNC() : RequestOptions.ASYNC();
        options.setExclusionList(new Address[]{this.dispatcher.getChannel().getAddress()});
        options.setTimeout(timeout);
        RspList rspList = this.dispatcher.castMessage(null, message, options);
        if (synchronous) {
            for (Rsp rsp : rspList.values()) {
                if (!rsp.wasReceived()) {
                    if (rsp.wasSuspected()) {
                        throw log.jgroupsSuspectingPeer(rsp.getSender());
                    }
                    throw log.jgroupsRpcTimeout(rsp.getSender());
                }
                if (!rsp.hasException()) continue;
                throw log.jgroupsRemoteException(rsp.getSender(), rsp.getException(), rsp.getException());
            }
        }
    }

    public void start(Properties props, BuildContext context) {
        log.jGroupsStartingChannelProvider();
        this.serviceManager = context.getServiceManager();
        this.channelContainer = DispatchMessageSender.buildChannel(props);
        this.channelContainer.start();
        NodeSelectorService masterNodeSelector = (NodeSelectorService)this.serviceManager.requestService(NodeSelectorService.class);
        LuceneWorkSerializer luceneWorkSerializer = (LuceneWorkSerializer)this.serviceManager.requestService(LuceneWorkSerializer.class);
        JGroupsMasterMessageListener listener = new JGroupsMasterMessageListener(context, masterNodeSelector, luceneWorkSerializer);
        JChannel channel = this.channelContainer.getChannel();
        UpHandler handler = channel.getUpHandler();
        if (handler instanceof Muxer) {
            Short muxId = (Short)props.get(MUX_ID);
            if (muxId == null) {
                throw log.missingJGroupsMuxId(MUX_ID);
            }
            Muxer muxer = (Muxer)handler;
            if (muxer.get(muxId.shortValue()) != null) {
                throw log.jGroupsMuxIdAlreadyTaken(muxId);
            }
            ClassLoader cl = (ClassLoader)props.get(CLASSLOADER);
            Object wrapper = cl != null ? new ClassloaderMessageListener((MessageListener)listener, cl) : listener;
            MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)wrapper);
            this.dispatcher = new MuxMessageDispatcher(muxId.shortValue(), (Channel)channel, (MessageListener)wrapper, (MembershipListener)listener, (RequestHandler)adapter);
        } else {
            MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)listener);
            this.dispatcher = new MessageDispatcher((Channel)channel, (MessageListener)listener, (MembershipListener)listener, (RequestHandler)adapter);
        }
        masterNodeSelector.setLocalAddress(channel.getAddress());
        if (!channel.flushSupported()) {
            log.jGroupsFlushNotPresentInStack();
        }
        if (log.isDebugEnabled()) {
            log.jgroupsFullConfiguration(channel.getProtocolStack().printProtocolSpecAsXML());
        }
    }

    public void stop() {
        this.serviceManager.releaseService(NodeSelectorService.class);
        this.serviceManager.releaseService(LuceneWorkSerializer.class);
        this.serviceManager = null;
        this.dispatcher.stop();
        try {
            if (this.channelContainer != null) {
                this.channelContainer.close();
                this.channelContainer = null;
            }
        }
        catch (Exception toLog) {
            log.jGroupsClosingChannelError(toLog);
        }
    }

    private static ChannelContainer buildChannel(Properties props) {
        String clusterName = ConfigurationParseHelper.getString((Properties)props, (String)CLUSTER_NAME, (String)DEFAULT_CLUSTER_NAME);
        if (props != null) {
            Object channelObject = props.get(CHANNEL_INJECT);
            if (channelObject != null) {
                try {
                    return new InjectedChannelContainer((JChannel)channelObject);
                }
                catch (ClassCastException e) {
                    throw log.jGroupsChannelInjectionError(CHANNEL_INJECT, e, channelObject.getClass());
                }
            }
            String cfg = props.getProperty(CONFIGURATION_FILE);
            if (cfg != null) {
                try {
                    log.startingJGroupsChannel(cfg);
                    return new ManagedChannelContainer(new JChannel(ConfigurationParseHelper.locateConfig((String)cfg)), clusterName);
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingFileError(cfg, e);
                }
            }
        }
        log.jGroupsConfigurationNotFoundInProperties(props);
        try {
            URL fileUrl = ConfigurationParseHelper.locateConfig((String)DEFAULT_JGROUPS_CONFIGURATION_FILE);
            if (fileUrl != null) {
                log.startingJGroupsChannel(fileUrl);
                return new ManagedChannelContainer(new JChannel(fileUrl), clusterName);
            }
            log.jGroupsDefaultConfigurationFileNotFound();
            return new ManagedChannelContainer(new JChannel(), clusterName);
        }
        catch (Exception e) {
            throw log.unableToStartJGroupsChannel(e);
        }
    }

    private static class InjectedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;

        InjectedChannelContainer(JChannel channel) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            this.channel = channel;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
        }

        @Override
        public void start() {
        }
    }

    private static class ManagedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;
        private final String clusterName;

        ManagedChannelContainer(JChannel channel, String clusterName) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            if (clusterName == null) {
                throw new NullPointerException("clusterName must not be null");
            }
            this.channel = channel;
            this.clusterName = clusterName;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
            log.jGroupsDisconnectingAndClosingChannel(this.clusterName);
            this.channel.disconnect();
            this.channel.close();
        }

        @Override
        public void start() {
            try {
                this.channel.connect(this.clusterName);
                log.jGroupsConnectedToCluster(this.clusterName, this.channel.getAddress());
            }
            catch (Exception e) {
                throw log.unableConnectingToJGroupsCluster(this.clusterName, e);
            }
        }
    }

    private static interface ChannelContainer {
        public JChannel getChannel();

        public void close();

        public void start();
    }
}

