/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.jgroups.impl.JGroupsBackendQueueTask;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.spi.BackendQueueProcessor;

public class JGroupsBackendQueueProcessor
implements BackendQueueProcessor {
    private final NodeSelectorStrategy selectionStrategy;
    private final JGroupsBackendQueueTask jgroupsProcessor;
    private final Supplier<BackendQueueProcessor> delegatedBackendFactory;
    private volatile BackendQueueProcessor delegate;

    public JGroupsBackendQueueProcessor(NodeSelectorStrategy selectionStrategy, JGroupsBackendQueueTask jgroupsProcessor, Supplier<BackendQueueProcessor> delegatedBackendFactory) {
        this.selectionStrategy = selectionStrategy;
        this.jgroupsProcessor = jgroupsProcessor;
        this.delegatedBackendFactory = delegatedBackendFactory;
        if (selectionStrategy.isIndexOwnerLocal()) {
            this.getOrCreateDelegate();
        }
    }

    public synchronized void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public void applyWork(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.getOrCreateDelegate().applyWork(workList, monitor);
        } else {
            if (workList == null) {
                throw new IllegalArgumentException("workList should not be null");
            }
            this.jgroupsProcessor.sendLuceneWorkList(workList);
        }
    }

    public void applyStreamWork(LuceneWork singleOperation, IndexingMonitor monitor) {
        if (this.selectionStrategy.isIndexOwnerLocal()) {
            this.getOrCreateDelegate().applyStreamWork(singleOperation, monitor);
        } else {
            this.jgroupsProcessor.sendLuceneWorkList(Collections.singletonList(singleOperation));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackendQueueProcessor getOrCreateDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        JGroupsBackendQueueProcessor jGroupsBackendQueueProcessor = this;
        synchronized (jGroupsBackendQueueProcessor) {
            if (this.delegate != null) {
                return this.delegate;
            }
            this.delegate = this.delegatedBackendFactory.get();
            return this.delegate;
        }
    }

    public boolean blocksForACK() {
        return this.jgroupsProcessor.blocksForACK();
    }

    public BackendQueueProcessor getExistingDelegate() {
        return this.delegate;
    }

    public long getMessageTimeout() {
        return this.jgroupsProcessor.getMessageTimeout();
    }
}

