/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.jgroups.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.jgroups.impl.MessageSenderService;
import org.hibernate.search.backend.jgroups.impl.MessageSerializationHelper;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorService;
import org.hibernate.search.backend.jgroups.impl.NodeSelectorStrategy;
import org.hibernate.search.backend.jgroups.logging.impl.Log;
import org.hibernate.search.indexes.serialization.spi.LuceneWorkSerializer;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Message;

public class JGroupsBackendQueueTask {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final MessageSenderService messageSender;
    private final String indexName;
    private final NodeSelectorStrategy masterNodeSelector;
    private final LuceneWorkSerializer luceneWorkSerializer;
    private final boolean blockForACK;
    private final long messageTimeout;

    public JGroupsBackendQueueTask(MessageSenderService messageSender, IndexManager indexManager, NodeSelectorService masterNodeSelector, LuceneWorkSerializer luceneWorkSerializer, boolean blockForACK, long messageTimeout) {
        this.messageSender = messageSender;
        this.blockForACK = blockForACK;
        this.messageTimeout = messageTimeout;
        this.indexName = indexManager.getIndexName();
        this.masterNodeSelector = masterNodeSelector.getMasterNodeSelector(this.indexName);
        this.luceneWorkSerializer = luceneWorkSerializer;
    }

    public void sendLuceneWorkList(List<LuceneWork> queue) {
        boolean trace = log.isTraceEnabled();
        ArrayList<LuceneWork> filteredQueue = new ArrayList<LuceneWork>(queue);
        if (trace) {
            log.tracef("Preparing %d Lucene works to be sent to master node.", filteredQueue.size());
        }
        for (LuceneWork work : queue) {
            if (!(work instanceof OptimizeLuceneWork)) continue;
            filteredQueue.remove(work);
        }
        if (trace) {
            log.tracef("Filtering: optimized Lucene works are not going to be sent to master node. There is %d Lucene works after filtering.", filteredQueue.size());
        }
        if (filteredQueue.isEmpty()) {
            if (trace) {
                log.trace("Nothing to send. Propagating works to a cluster has been skipped.");
            }
            return;
        }
        byte[] data = this.luceneWorkSerializer.toSerializedModel(filteredQueue);
        data = MessageSerializationHelper.prependString(this.indexName, data);
        try {
            Message message = this.masterNodeSelector.createMessage(data);
            this.messageSender.send(message, this.blockForACK, this.messageTimeout);
            if (trace) {
                log.tracef("Lucene works have been sent from slave %s to master node.", this.messageSender.getAddress());
            }
        }
        catch (Exception e) {
            throw log.unableToSendWorkViaJGroups(e);
        }
    }

    public boolean blocksForACK() {
        return this.blockForACK;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }
}

