/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Map;
import java.util.Objects;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;

public class SimpleElasticsearchAnalysisDefinitionRegistryPopulator
implements ElasticsearchAnalysisDefinitionRegistryPopulator {
    private final String analyzerName;
    private final AnalyzerDefinition analyzerDefinition;
    private final TokenizerDefinition tokenizerDefinition;
    private final NormalizerDefinition normalizerDefinition;
    private final Map<String, CharFilterDefinition> charFilters;
    private final Map<String, TokenFilterDefinition> tokenFilters;

    public SimpleElasticsearchAnalysisDefinitionRegistryPopulator(String analyzerName, AnalyzerDefinition analyzerDefinition, String tokenizerName, TokenizerDefinition tokenizerDefinition, Map<String, CharFilterDefinition> charFilters, Map<String, TokenFilterDefinition> tokenFilters) {
        this(analyzerName, analyzerDefinition, tokenizerName, tokenizerDefinition, null, charFilters, tokenFilters);
    }

    public SimpleElasticsearchAnalysisDefinitionRegistryPopulator(String analyzerName, NormalizerDefinition normalizerDefinition, Map<String, CharFilterDefinition> charFilters, Map<String, TokenFilterDefinition> tokenFilters) {
        this(analyzerName, null, null, null, normalizerDefinition, charFilters, tokenFilters);
    }

    private SimpleElasticsearchAnalysisDefinitionRegistryPopulator(String analyzerName, AnalyzerDefinition analyzerDefinition, String tokenizerName, TokenizerDefinition tokenizerDefinition, NormalizerDefinition normalizerDefinition, Map<String, CharFilterDefinition> charFilters, Map<String, TokenFilterDefinition> tokenFilters) {
        this.analyzerName = analyzerName;
        this.analyzerDefinition = analyzerDefinition;
        this.tokenizerDefinition = tokenizerDefinition;
        this.normalizerDefinition = normalizerDefinition;
        this.charFilters = charFilters;
        this.tokenFilters = tokenFilters;
    }

    @Override
    public void populate(ElasticsearchAnalysisDefinitionRegistry registry) {
        if (this.analyzerDefinition != null) {
            registry.register(this.analyzerName, this.analyzerDefinition);
        }
        if (this.tokenizerDefinition != null) {
            registry.register(this.analyzerDefinition.getTokenizer(), this.tokenizerDefinition);
        }
        if (this.normalizerDefinition != null) {
            registry.register(this.analyzerName, this.normalizerDefinition);
        }
        for (Map.Entry<String, CharFilterDefinition> entry : this.charFilters.entrySet()) {
            registry.register(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, AnalysisDefinition> entry : this.tokenFilters.entrySet()) {
            registry.register(entry.getKey(), (TokenFilterDefinition)entry.getValue());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this.analyzerName);
        result = 31 * result + Objects.hashCode(this.analyzerDefinition);
        result = 31 * result + Objects.hashCode(this.tokenizerDefinition);
        result = 31 * result + Objects.hashCode(this.normalizerDefinition);
        result = 31 * result + Objects.hashCode(this.charFilters);
        result = 31 * result + Objects.hashCode(this.tokenFilters);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleElasticsearchAnalysisDefinitionRegistryPopulator) {
            SimpleElasticsearchAnalysisDefinitionRegistryPopulator other = (SimpleElasticsearchAnalysisDefinitionRegistryPopulator)obj;
            return Objects.equals(this.analyzerName, other.analyzerName) && Objects.equals(this.analyzerDefinition, other.analyzerDefinition) && Objects.equals(this.tokenizerDefinition, other.tokenizerDefinition) && Objects.equals(this.normalizerDefinition, other.normalizerDefinition) && Objects.equals(this.charFilters, other.charFilters) && Objects.equals(this.tokenFilters, other.tokenFilters);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.analyzerName);
        sb.append(", ");
        sb.append(this.analyzerDefinition != null ? this.analyzerDefinition : this.normalizerDefinition);
        sb.append(">");
        return sb.toString();
    }
}

