/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.processor.impl.ContextualErrorHandler;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;

class DefaultContextualErrorHandler
implements ContextualErrorHandler {
    private final ErrorHandler errorHandler;
    private ErrorContextBuilder errorContextBuilder;
    private Throwable errorThatOccurred;

    public DefaultContextualErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void markAsFailed(ElasticsearchWork<?> work, Throwable throwable) {
        LuceneWork luceneWork = work.getLuceneWork();
        if (luceneWork != null) {
            this.getErrorContextBuilder().operationAtFault(luceneWork);
            this.getErrorContextBuilder().addWorkThatFailed(luceneWork);
        }
        this.addThrowable(throwable);
    }

    @Override
    public void markAsSkipped(ElasticsearchWork<?> work) {
        LuceneWork luceneWork = work.getLuceneWork();
        if (luceneWork != null) {
            this.getErrorContextBuilder().addWorkThatFailed(luceneWork);
        }
    }

    @Override
    public void addThrowable(Throwable throwable) {
        if (this.errorThatOccurred == null) {
            this.errorThatOccurred = throwable;
        } else {
            this.errorThatOccurred.addSuppressed(throwable);
        }
    }

    @Override
    public void handle() {
        if (this.errorContextBuilder != null || this.errorThatOccurred != null) {
            if (this.errorThatOccurred != null) {
                this.getErrorContextBuilder().errorThatOccurred(this.errorThatOccurred);
            }
            this.errorHandler.handle(this.getErrorContextBuilder().createErrorContext());
        }
    }

    private ErrorContextBuilder getErrorContextBuilder() {
        if (this.errorContextBuilder == null) {
            this.errorContextBuilder = new ErrorContextBuilder();
        }
        return this.errorContextBuilder;
    }
}

